/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.handlers.steamuserstats;

import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesClientserverLbs;
import in.dragonbra.javasteam.types.SteamID;
import in.dragonbra.javasteam.types.UGCHandle;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuserstats/LeaderboardEntry;", "", "entry", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverLbs$CMsgClientLBSGetLBEntriesResponse$Entry;", "<init>", "(Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesClientserverLbs$CMsgClientLBSGetLBEntriesResponse$Entry;)V", "steamID", "Lin/dragonbra/javasteam/types/SteamID;", "getSteamID", "()Lin/dragonbra/javasteam/types/SteamID;", "globalRank", "", "getGlobalRank", "()I", "score", "getScore", "ugcId", "Lin/dragonbra/javasteam/types/UGCHandle;", "getUgcId", "()Lin/dragonbra/javasteam/types/UGCHandle;", "details", "", "getDetails", "()Ljava/util/List;", "Companion", "javasteam"})
public final class LeaderboardEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SteamID steamID;
    private final int globalRank;
    private final int score;
    @NotNull
    private final UGCHandle ugcId;
    @NotNull
    private final List<Integer> details;
    private static final Logger logger = LogManager.getLogger(LeaderboardEntry.class);

    public LeaderboardEntry(@NotNull SteammessagesClientserverLbs.CMsgClientLBSGetLBEntriesResponse.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.steamID = new SteamID(entry.getSteamIdUser());
        this.globalRank = entry.getGlobalRank();
        this.score = entry.getScore();
        this.ugcId = new UGCHandle(entry.getUgcId());
        List entryDetails = new ArrayList();
        if (entry.getDetails() != null) {
            MemoryStream ms = new MemoryStream(entry.getDetails().toByteArray());
            BinaryReader br = new BinaryReader(ms);
            try {
                while (ms.getLength() - ms.getPosition() > 4L) {
                    entryDetails.add(br.readInt());
                }
            }
            catch (IOException e) {
                logger.error("failed to read details", e);
            }
        }
        this.details = CollectionsKt.toList((Iterable)entryDetails);
    }

    @NotNull
    public final SteamID getSteamID() {
        return this.steamID;
    }

    public final int getGlobalRank() {
        return this.globalRank;
    }

    public final int getScore() {
        return this.score;
    }

    @NotNull
    public final UGCHandle getUgcId() {
        return this.ugcId;
    }

    @NotNull
    public final List<Integer> getDetails() {
        return this.details;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/handlers/steamuserstats/LeaderboardEntry$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

