/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.steamclient;

import in.dragonbra.javasteam.steam.steamclient.callbackmgr.CallbackMsg;
import in.dragonbra.javasteam.types.AsyncJob;
import in.dragonbra.javasteam.types.JobID;
import in.dragonbra.javasteam.util.event.ScheduledFunction;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\rH\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/AsyncJobManager;", "", "<init>", "()V", "asyncJobs", "Ljava/util/concurrent/ConcurrentMap;", "Lin/dragonbra/javasteam/types/JobID;", "Lin/dragonbra/javasteam/types/AsyncJob;", "getAsyncJobs", "()Ljava/util/concurrent/ConcurrentMap;", "jobTimeoutFunc", "Lin/dragonbra/javasteam/util/event/ScheduledFunction;", "startJob", "", "asyncJob", "tryCompleteJob", "jobID", "callback", "Lin/dragonbra/javasteam/steam/steamclient/callbackmgr/CallbackMsg;", "heartbeatJob", "failJob", "cancelPendingJobs", "setTimeoutsEnabled", "enable", "", "cancelTimedOutJobs", "getJob", "andRemove", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nAsyncJobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncJobManager.kt\nin/dragonbra/javasteam/steam/steamclient/AsyncJobManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1869#2,2:140\n1869#2,2:142\n*S KotlinDebug\n*F\n+ 1 AsyncJobManager.kt\nin/dragonbra/javasteam/steam/steamclient/AsyncJobManager\n*L\n85#1:140,2\n109#1:142,2\n*E\n"})
public final class AsyncJobManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<JobID, AsyncJob> asyncJobs = new ConcurrentHashMap();
    @NotNull
    private final ScheduledFunction jobTimeoutFunc = new ScheduledFunction(this::cancelTimedOutJobs, 1000L);
    private static final Logger logger = LogManager.getLogger(AsyncJobManager.class);

    @NotNull
    public final ConcurrentMap<JobID, AsyncJob> getAsyncJobs() {
        return this.asyncJobs;
    }

    public final void startJob(@NotNull AsyncJob asyncJob) {
        Intrinsics.checkNotNullParameter((Object)asyncJob, (String)"asyncJob");
        ((Map)this.asyncJobs).put(asyncJob.getJobID(), asyncJob);
    }

    public final void tryCompleteJob(@NotNull JobID jobID, @NotNull CallbackMsg callback) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        AsyncJob asyncJob = AsyncJobManager.getJob$default(this, jobID, false, 2, null);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        boolean jobFinished = asyncJob2.addResult(callback);
        if (jobFinished) {
            this.asyncJobs.remove(jobID);
        }
    }

    public final void heartbeatJob(@NotNull JobID jobID) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        AsyncJob asyncJob = AsyncJobManager.getJob$default(this, jobID, false, 2, null);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        asyncJob2.heartbeat();
    }

    public final void failJob(@NotNull JobID jobID) {
        Intrinsics.checkNotNullParameter((Object)jobID, (String)"jobID");
        logger.debug("Failing job id: " + jobID);
        AsyncJob asyncJob = this.getJob(jobID, true);
        if (asyncJob == null) {
            return;
        }
        AsyncJob asyncJob2 = asyncJob;
        asyncJob2.setFailed(true);
    }

    public final void cancelPendingJobs() {
        Iterable $this$forEach$iv = this.asyncJobs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncJob job = (AsyncJob)element$iv;
            boolean bl = false;
            job.setFailed(false);
        }
        this.asyncJobs.clear();
    }

    public final void setTimeoutsEnabled(boolean enable) {
        if (enable) {
            this.jobTimeoutFunc.start();
        } else {
            this.jobTimeoutFunc.stop();
        }
    }

    private final void cancelTimedOutJobs() {
        Iterable $this$forEach$iv = this.asyncJobs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AsyncJob job = (AsyncJob)element$iv;
            boolean bl = false;
            if (!job.isTimedOut()) continue;
            job.setFailed(false);
            this.asyncJobs.remove(job.getJobID());
        }
    }

    private final AsyncJob getJob(JobID jobID, boolean andRemove) {
        AsyncJob asyncJob = null;
        boolean foundJob = false;
        if (andRemove) {
            asyncJob = (AsyncJob)this.asyncJobs.get(jobID);
            foundJob = this.asyncJobs.remove(jobID, this.asyncJobs.get(jobID));
        } else {
            asyncJob = (AsyncJob)this.asyncJobs.get(jobID);
            foundJob = asyncJob != null;
        }
        return foundJob ? asyncJob : null;
    }

    static /* synthetic */ AsyncJob getJob$default(AsyncJobManager asyncJobManager, JobID jobID, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return asyncJobManager.getJob(jobID, bl);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/steam/steamclient/AsyncJobManager$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

