/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.steam.webapi;

import in.dragonbra.javasteam.steam.discovery.ServerRecord;
import in.dragonbra.javasteam.steam.steamclient.configuration.SteamConfiguration;
import in.dragonbra.javasteam.steam.webapi.WebAPI;
import in.dragonbra.javasteam.types.KeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lin/dragonbra/javasteam/steam/webapi/SteamDirectory;", "", "<init>", "()V", "load", "", "Lin/dragonbra/javasteam/steam/discovery/ServerRecord;", "configuration", "Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;", "maxServers", "", "(Lin/dragonbra/javasteam/steam/steamclient/configuration/SteamConfiguration;Ljava/lang/Integer;)Ljava/util/List;", "loadCore", "javasteam"})
@SourceDebugExtension(value={"SMAP\nSteamDirectory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteamDirectory.kt\nin/dragonbra/javasteam/steam/webapi/SteamDirectory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1#2:66\n1869#3,2:67\n*S KotlinDebug\n*F\n+ 1 SteamDirectory.kt\nin/dragonbra/javasteam/steam/webapi/SteamDirectory\n*L\n48#1:67,2\n*E\n"})
public final class SteamDirectory {
    @NotNull
    public static final SteamDirectory INSTANCE = new SteamDirectory();

    private SteamDirectory() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<ServerRecord> load(@NotNull SteamConfiguration configuration, @Nullable Integer maxServers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return INSTANCE.loadCore(configuration, maxServers);
    }

    public static /* synthetic */ List load$default(SteamConfiguration steamConfiguration, Integer n, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return SteamDirectory.load(steamConfiguration, n);
    }

    private final List<ServerRecord> loadCore(SteamConfiguration configuration, Integer maxServers) throws IOException {
        HashMap<String, String> params;
        KeyValue response;
        HashMap<String, String> hashMap;
        WebAPI api = configuration.getWebAPI("ISteamDirectory");
        HashMap<String, String> $this$loadCore_u24lambda_u241 = hashMap = new HashMap<String, String>();
        boolean bl = false;
        $this$loadCore_u24lambda_u241.put("cellid", String.valueOf(configuration.getCellID()));
        Integer n = maxServers;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$loadCore_u24lambda_u241.put("maxcount", String.valueOf(it));
        }
        if (!KeyValue.asBoolean$default((response = api.call("GetCMListForConnect", (Map<String, String>)(params = hashMap))).get("success"), false, 1, null)) {
            String string = response.get("message").asString();
            if (string == null) {
                string = "unknown";
            }
            throw new IOException("Steam Web API returned EResult." + string);
        }
        KeyValue socketList = response.get("serverlist");
        ArrayList<ServerRecord> serverRecords = new ArrayList<ServerRecord>(socketList.getChildren().size());
        Iterable $this$forEach$iv = socketList.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String endPoint;
            String string;
            ServerRecord record;
            KeyValue child = (KeyValue)element$iv;
            boolean bl3 = false;
            if (child.get("endPoint").getValue() == null || (record = Intrinsics.areEqual((Object)(string = child.get("type").getValue()), (Object)"websockets") ? ServerRecord.Companion.createWebSocketServer(endPoint) : (Intrinsics.areEqual((Object)string, (Object)"netfilter") ? ServerRecord.Companion.tryCreateSocketServer(endPoint) : null)) == null) continue;
            serverRecords.add(record);
        }
        return serverRecords;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<ServerRecord> load(@NotNull SteamConfiguration configuration) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return SteamDirectory.load$default(configuration, null, 2, null);
    }
}

