/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.enums.EDepotFileFlag;
import in.dragonbra.javasteam.protobufs.steamclient.ContentManifest;
import in.dragonbra.javasteam.types.ChunkData;
import in.dragonbra.javasteam.types.FileData;
import in.dragonbra.javasteam.types.Steam3Manifest;
import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.compat.InputStreamCompatKt;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0010\u00104\u001a\u0002012\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0002012\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020?H\u0002J\u000e\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020BR*\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u001a\u0010'\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\u001a\u0010*\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017\u00a8\u0006D"}, d2={"Lin/dragonbra/javasteam/types/DepotManifest;", "", "<init>", "()V", "files", "Ljava/util/ArrayList;", "Lin/dragonbra/javasteam/types/FileData;", "Lkotlin/collections/ArrayList;", "getFiles", "()Ljava/util/ArrayList;", "setFiles", "(Ljava/util/ArrayList;)V", "filenamesEncrypted", "", "getFilenamesEncrypted", "()Z", "setFilenamesEncrypted", "(Z)V", "depotID", "", "getDepotID", "()I", "setDepotID", "(I)V", "manifestGID", "", "getManifestGID", "()J", "setManifestGID", "(J)V", "creationTime", "Ljava/util/Date;", "getCreationTime", "()Ljava/util/Date;", "setCreationTime", "(Ljava/util/Date;)V", "totalUncompressedSize", "getTotalUncompressedSize", "setTotalUncompressedSize", "totalCompressedSize", "getTotalCompressedSize", "setTotalCompressedSize", "encryptedCRC", "getEncryptedCRC", "setEncryptedCRC", "decryptFilenames", "encryptionKey", "", "saveToFile", "", "filename", "", "internalDeserialize", "stream", "Ljava/io/InputStream;", "parseBinaryManifest", "manifest", "Lin/dragonbra/javasteam/types/Steam3Manifest;", "parseProtobufManifestPayload", "payload", "Lin/dragonbra/javasteam/protobufs/steamclient/ContentManifest$ContentManifestPayload;", "parseProtobufManifestMetadata", "metadata", "Lin/dragonbra/javasteam/protobufs/steamclient/ContentManifest$ContentManifestMetadata;", "serialize", "output", "Ljava/io/OutputStream;", "Companion", "javasteam"})
@SourceDebugExtension(value={"SMAP\nDepotManifest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DepotManifest.kt\nin/dragonbra/javasteam/types/DepotManifest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,504:1\n1#2:505\n1869#3,2:506\n1869#3:508\n1870#3:511\n1869#3:512\n1869#3,2:513\n1870#3:515\n1869#3:516\n1869#3,2:517\n1870#3:519\n13472#4,2:509\n*S KotlinDebug\n*F\n+ 1 DepotManifest.kt\nin/dragonbra/javasteam/types/DepotManifest\n*L\n149#1:506,2\n307#1:508\n307#1:511\n337#1:512\n349#1:513,2\n337#1:515\n398#1:516\n426#1:517,2\n398#1:519\n319#1:509,2\n*E\n"})
public final class DepotManifest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<FileData> files = new ArrayList();
    private boolean filenamesEncrypted;
    private int depotID;
    private long manifestGID;
    @NotNull
    private Date creationTime = new Date();
    private long totalUncompressedSize;
    private long totalCompressedSize;
    private int encryptedCRC;
    @NotNull
    private static final Logger logger;
    private static final int PROTOBUF_PAYLOAD_MAGIC = 1911953360;
    private static final int PROTOBUF_METADATA_MAGIC = 524817086;
    private static final int PROTOBUF_SIGNATURE_MAGIC = 461486103;
    private static final int PROTOBUF_ENDOFMANIFEST_MAGIC = 851711403;

    @NotNull
    public final ArrayList<FileData> getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull ArrayList<FileData> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.files = arrayList;
    }

    public final boolean getFilenamesEncrypted() {
        return this.filenamesEncrypted;
    }

    public final void setFilenamesEncrypted(boolean bl) {
        this.filenamesEncrypted = bl;
    }

    public final int getDepotID() {
        return this.depotID;
    }

    public final void setDepotID(int n) {
        this.depotID = n;
    }

    public final long getManifestGID() {
        return this.manifestGID;
    }

    public final void setManifestGID(long l) {
        this.manifestGID = l;
    }

    @NotNull
    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final void setCreationTime(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
        this.creationTime = date;
    }

    public final long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    public final void setTotalUncompressedSize(long l) {
        this.totalUncompressedSize = l;
    }

    public final long getTotalCompressedSize() {
        return this.totalCompressedSize;
    }

    public final void setTotalCompressedSize(long l) {
        this.totalCompressedSize = l;
    }

    public final int getEncryptedCRC() {
        return this.encryptedCRC;
    }

    public final void setEncryptedCRC(int n) {
        this.encryptedCRC = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean decryptFilenames(@NotNull byte[] encryptionKey) {
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        if (!this.filenamesEncrypted) {
            return true;
        }
        if (!(encryptionKey.length == 32)) {
            boolean $i$a$-require-DepotManifest$decryptFilenames$22 = false;
            String $i$a$-require-DepotManifest$decryptFilenames$22 = "Decrypt filnames used with non 32 byte key!";
            throw new IllegalArgumentException($i$a$-require-DepotManifest$decryptFilenames$22.toString());
        }
        Cipher ecbCipher = Cipher.getInstance("AES/ECB/NoPadding", CryptoHelper.SEC_PROV);
        Cipher aes = Cipher.getInstance("AES/CBC/PKCS7Padding", CryptoHelper.SEC_PROV);
        SecretKeySpec secretKey = new SecretKeySpec(encryptionKey, "AES");
        byte[] iv = new byte[16];
        int filenameLength = 0;
        byte[] bufferDecoded = null;
        bufferDecoded = new byte[256];
        byte[] bufferDecrypted = null;
        bufferDecrypted = new byte[256];
        try {
            Iterable $this$forEach$iv = this.files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int tempBytes22;
                FileData file = (FileData)element$iv;
                boolean bl = false;
                int decodedLength = file.getFileName().length() / 4 * 3;
                if (decodedLength > bufferDecoded.length) {
                    bufferDecoded = new byte[decodedLength];
                    bufferDecrypted = new byte[decodedLength];
                }
                Base64.Decoder decoder = Base64.getUrlDecoder();
                try {
                    byte[] tempBytes22 = decoder.decode(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)file.getFileName(), (char)'+', (char)'-', (boolean)false, (int)4, null), (char)'/', (char)'_', (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null));
                    if (tempBytes22.length > bufferDecoded.length) {
                        throw new IllegalArgumentException("Buffer too small");
                    }
                    Intrinsics.checkNotNull((Object)tempBytes22);
                    ArraysKt.copyInto$default((byte[])tempBytes22, (byte[])bufferDecoded, (int)0, (int)0, (int)0, (int)14, null);
                    tempBytes22 = tempBytes22.length;
                }
                catch (Exception e) {
                    logger.error("Failed to base64 decode the filename: " + e.getMessage(), e);
                    boolean bl2 = false;
                    ArraysKt.fill$default((byte[])bufferDecoded, (byte)0, (int)0, (int)0, (int)6, null);
                    ArraysKt.fill$default((byte[])bufferDecrypted, (byte)0, (int)0, (int)0, (int)6, null);
                    return bl2;
                }
                decodedLength = tempBytes22;
                try {
                    byte[] encryptedFilename = ArraysKt.copyOfRange((byte[])bufferDecoded, (int)0, (int)decodedLength);
                    ecbCipher.init(2, secretKey);
                    ecbCipher.doFinal(encryptedFilename, 0, iv.length, iv, 0);
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    aes.init(2, (Key)secretKey, ivSpec);
                    byte[] remainingData = ArraysKt.copyOfRange((byte[])encryptedFilename, (int)iv.length, (int)encryptedFilename.length);
                    filenameLength = aes.doFinal(remainingData, 0, remainingData.length, bufferDecrypted, 0);
                }
                catch (Exception e) {
                    logger.error("Failed to decrypt the filename.", e);
                    boolean bl3 = false;
                    ArraysKt.fill$default((byte[])bufferDecoded, (byte)0, (int)0, (int)0, (int)6, null);
                    ArraysKt.fill$default((byte[])bufferDecrypted, (byte)0, (int)0, (int)0, (int)6, null);
                    return bl3;
                }
                if (filenameLength > 0 && bufferDecrypted[filenameLength - 1] == 0) {
                    filenameLength += -1;
                }
                int n = filenameLength;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (bufferDecrypted[i2] != 92) continue;
                    bufferDecrypted[i2] = (byte)File.separatorChar;
                }
                file.setFileName(new String(bufferDecrypted, 0, filenameLength, Charsets.UTF_8));
            }
        }
        finally {
            ArraysKt.fill$default((byte[])bufferDecoded, (byte)0, (int)0, (int)0, (int)6, null);
            ArraysKt.fill$default((byte[])bufferDecrypted, (byte)0, (int)0, (int)0, (int)6, null);
        }
        Comparator comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
        CollectionsKt.sortWith((List)this.files, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                FileData fileData = (FileData)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                FileData it = (FileData)b;
                String string = it.getFileName();
                bl = false;
                String string2 = it.getFileName();
                return comparator.compare(string, string2);
            }
        });
        this.filenamesEncrypted = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveToFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Closeable closeable = new FileOutputStream(new File(filename));
        Throwable throwable = null;
        try {
            FileOutputStream fileStream = (FileOutputStream)closeable;
            boolean bl = false;
            this.serialize(fileStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalDeserialize(InputStream stream) {
        ContentManifest.ContentManifestPayload payload = null;
        ContentManifest.ContentManifestMetadata metadata = null;
        ContentManifest.ContentManifestSignature signature = null;
        Closeable closeable = new BinaryReader(stream);
        Throwable throwable = null;
        try {
            int magic;
            BinaryReader br = (BinaryReader)closeable;
            boolean bl = false;
            block12: while ((magic = br.readInt()) != 851711403) {
                switch (magic) {
                    case 372545409: {
                        Steam3Manifest binaryManifest = new Steam3Manifest();
                        binaryManifest.deserialize$javasteam(br);
                        this.parseBinaryManifest(binaryManifest);
                        int marker = br.readInt();
                        if (marker != magic) {
                            throw new NoSuchElementException("Unable to find end of message marker for depot manifest");
                        }
                        return;
                    }
                    case 1911953360: {
                        int payloadLength = br.readInt();
                        payload = ContentManifest.ContentManifestPayload.parseFrom(InputStreamCompatKt.readNBytesCompat(stream, payloadLength));
                        continue block12;
                    }
                    case 524817086: {
                        int metadataLength = br.readInt();
                        metadata = ContentManifest.ContentManifestMetadata.parseFrom(InputStreamCompatKt.readNBytesCompat(stream, metadataLength));
                        continue block12;
                    }
                    case 461486103: {
                        int signatureLength = br.readInt();
                        signature = ContentManifest.ContentManifestSignature.parseFrom(InputStreamCompatKt.readNBytesCompat(stream, signatureLength));
                        continue block12;
                    }
                }
                throw new NoSuchElementException("Unrecognized magic value " + HexExtensionsKt.toHexString$default((int)magic, null, (int)1, null) + " in depot manifest.");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (payload == null || metadata == null || signature == null) {
            throw new NoSuchElementException("Missing ContentManifest sections required for parsing depot manifest");
        }
        this.parseProtobufManifestMetadata(metadata);
        this.parseProtobufManifestPayload(payload);
    }

    private final void parseBinaryManifest(Steam3Manifest manifest) {
        this.files = new ArrayList(manifest.getMapping().size());
        this.filenamesEncrypted = manifest.getAreFileNamesEncrypted();
        this.depotID = manifest.getDepotID();
        this.manifestGID = manifest.getManifestGID();
        this.creationTime = manifest.getCreationTime();
        this.totalUncompressedSize = manifest.getTotalUncompressedSize();
        this.totalCompressedSize = manifest.getTotalCompressedSize();
        this.encryptedCRC = manifest.getEncryptedCRC();
        Iterable $this$forEach$iv = manifest.getMapping();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Steam3Manifest.FileMapping fileMapping = (Steam3Manifest.FileMapping)element$iv;
            boolean bl = false;
            String string = fileMapping.getFileName();
            Intrinsics.checkNotNull((Object)string);
            byte[] byArray = fileMapping.getHashFileName();
            Intrinsics.checkNotNull((Object)byArray);
            EnumSet<EDepotFileFlag> enumSet = fileMapping.getFlags();
            long l = fileMapping.getTotalSize();
            byte[] byArray2 = fileMapping.getHashContent();
            Intrinsics.checkNotNull((Object)byArray2);
            FileData filedata = new FileData(string, byArray, enumSet, l, byArray2, "", this.filenamesEncrypted, fileMapping.getChunks().length);
            Steam3Manifest.FileMapping.Chunk[] $this$forEach$iv2 = fileMapping.getChunks();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int j = 0; j < n; ++j) {
                Steam3Manifest.FileMapping.Chunk element$iv2;
                Steam3Manifest.FileMapping.Chunk chunk = element$iv2 = $this$forEach$iv2[j];
                boolean bl2 = false;
                byte[] byArray3 = chunk.getChunkGID();
                Intrinsics.checkNotNull((Object)byArray3);
                ChunkData chunkData = new ChunkData(byArray3, chunk.getChecksum(), chunk.getOffset(), chunk.getCompressedSize(), chunk.getDecompressedSize());
                filedata.getChunks().add(chunkData);
            }
            this.files.add(filedata);
        }
    }

    private final void parseProtobufManifestPayload(ContentManifest.ContentManifestPayload payload) {
        this.files = new ArrayList(payload.getMappingsCount());
        List<ContentManifest.ContentManifestPayload.FileMapping> list = payload.getMappingsList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappingsList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentManifest.ContentManifestPayload.FileMapping fileMapping = (ContentManifest.ContentManifestPayload.FileMapping)element$iv;
            boolean bl = false;
            String string = fileMapping.getFilename();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilename(...)");
            byte[] byArray = fileMapping.getShaFilename().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            EnumSet<EDepotFileFlag> enumSet = EDepotFileFlag.from(fileMapping.getFlags());
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
            long l = fileMapping.getSize();
            byte[] byArray2 = fileMapping.getShaContent().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            String string2 = fileMapping.getLinktarget();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLinktarget(...)");
            FileData filedata = new FileData(string, byArray, enumSet, l, byArray2, string2, this.filenamesEncrypted, fileMapping.getChunksList().size());
            List<ContentManifest.ContentManifestPayload.FileMapping.ChunkData> list2 = fileMapping.getChunksList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getChunksList(...)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContentManifest.ContentManifestPayload.FileMapping.ChunkData chunk = (ContentManifest.ContentManifestPayload.FileMapping.ChunkData)element$iv2;
                boolean bl2 = false;
                ChunkData chunkData = new ChunkData(chunk.getSha().toByteArray(), chunk.getCrc(), chunk.getOffset(), chunk.getCbCompressed(), chunk.getCbOriginal());
                filedata.getChunks().add(chunkData);
            }
            this.files.add(filedata);
        }
    }

    private final void parseProtobufManifestMetadata(ContentManifest.ContentManifestMetadata metadata) {
        this.filenamesEncrypted = metadata.getFilenamesEncrypted();
        this.depotID = metadata.getDepotId();
        this.manifestGID = metadata.getGidManifest();
        Date date = Date.from(Instant.ofEpochSecond(metadata.getCreationTime()));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(...)");
        this.creationTime = date;
        this.totalUncompressedSize = metadata.getCbDiskOriginal();
        this.totalCompressedSize = metadata.getCbDiskCompressed();
        this.encryptedCRC = metadata.getCrcEncrypted();
    }

    public final void serialize(@NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ContentManifest.ContentManifestPayload.Builder payload = ContentManifest.ContentManifestPayload.newBuilder();
        var uniqueChunks2 = new HashSet<byte[]>(){
            private final List<byte[]> items;
            {
                this.items = new ArrayList<E>();
            }

            public boolean add(byte[] element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.contains((Object)element)) {
                    return false;
                }
                this.items.add(element);
                return true;
            }

            public boolean contains(byte[] element) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Iterable $this$any$iv = this.items;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            byte[] it = (byte[])element$iv;
                            boolean bl2 = false;
                            if (!Arrays.equals(it, element)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public Iterator<byte[]> iterator() {
                return this.items.iterator();
            }

            public int getSize() {
                return this.items.size();
            }
        };
        Iterable $this$forEach$iv = this.files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileData file = (FileData)element$iv;
            boolean bl = false;
            Object object = ContentManifest.ContentManifestPayload.FileMapping.newBuilder();
            ContentManifest.ContentManifestPayload.FileMapping.Builder $this$serialize_u24lambda_u2412_u24lambda_u249 = object;
            boolean bl2 = false;
            $this$serialize_u24lambda_u2412_u24lambda_u249.setSize(file.getTotalSize());
            $this$serialize_u24lambda_u2412_u24lambda_u249.setFlags(EDepotFileFlag.code(file.getFlags()));
            ContentManifest.ContentManifestPayload.FileMapping.Builder protofile = object;
            if (this.filenamesEncrypted) {
                protofile.setFilename(file.getFileName());
                protofile.setShaFilename(ByteString.copyFrom((byte[])file.getFileNameHash()));
            } else {
                protofile.setFilename(StringsKt.replace$default((String)file.getFileName(), (char)'/', (char)'\\', (boolean)false, (int)4, null));
                object = StringsKt.replace$default((String)file.getFileName(), (char)'/', (char)'\\', (boolean)false, (int)4, null);
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string = ((String)object).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                protofile.setShaFilename(ByteString.copyFrom((byte[])CryptoHelper.shaHash(byArray)));
            }
            protofile.setShaContent(ByteString.copyFrom((byte[])file.getFileHash()));
            object = file.getLinkTarget();
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                protofile.setLinktarget(file.getLinkTarget());
            }
            Iterable $this$forEach$iv2 = file.getChunks();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ContentManifest.ContentManifestPayload.FileMapping.ChunkData.Builder builder;
                ChunkData chunk = (ChunkData)element$iv2;
                boolean bl3 = false;
                ContentManifest.ContentManifestPayload.FileMapping.ChunkData.Builder $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = builder = ContentManifest.ContentManifestPayload.FileMapping.ChunkData.newBuilder();
                boolean bl4 = false;
                $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setSha(ByteString.copyFrom((byte[])chunk.getChunkID()));
                $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setCrc(chunk.getChecksum());
                $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setOffset(chunk.getOffset());
                $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setCbOriginal(chunk.getUncompressedLength());
                $this$serialize_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setCbCompressed(chunk.getCompressedLength());
                ContentManifest.ContentManifestPayload.FileMapping.ChunkData protochunk = builder.build();
                protofile.addChunks(protochunk);
                byte[] byArray = chunk.getChunkID();
                Intrinsics.checkNotNull((Object)byArray);
                uniqueChunks2.add(byArray);
            }
            payload.addMappings(protofile.build());
        }
        ContentManifest.ContentManifestMetadata.Builder $this$serialize_u24lambda_u2413 = $i$f$forEach = ContentManifest.ContentManifestMetadata.newBuilder();
        boolean bl = false;
        $this$serialize_u24lambda_u2413.setDepotId(this.depotID);
        $this$serialize_u24lambda_u2413.setGidManifest(this.manifestGID);
        $this$serialize_u24lambda_u2413.setCreationTime((int)(this.creationTime.getTime() / (long)1000));
        $this$serialize_u24lambda_u2413.setFilenamesEncrypted(this.filenamesEncrypted);
        $this$serialize_u24lambda_u2413.setCbDiskOriginal(this.totalUncompressedSize);
        $this$serialize_u24lambda_u2413.setCbDiskCompressed(this.totalCompressedSize);
        $this$serialize_u24lambda_u2413.setUniqueChunks(uniqueChunks2.size());
        ContentManifest.ContentManifestMetadata.Builder metadata = $i$f$forEach;
        MemoryStream msPayload = new MemoryStream();
        payload.build().writeTo(msPayload.asOutputStream());
        int len = (int)msPayload.getLength();
        byte[] data = new byte[4 + len];
        byte[] lenBytes = new byte[]{(byte)(len & 0xFF), (byte)(len >> 8 & 0xFF), (byte)(len >> 16 & 0xFF), (byte)(len >> 24 & 0xFF)};
        System.arraycopy(lenBytes, 0, data, 0, 4);
        System.arraycopy(msPayload.toByteArray(), 0, data, 4, len);
        int crc32 = (int)Utils.crc32(data);
        msPayload.close();
        if (this.filenamesEncrypted) {
            metadata.setCrcEncrypted(crc32);
            metadata.setCrcClear(0);
        } else {
            metadata.setCrcEncrypted(this.encryptedCRC);
            metadata.setCrcClear(crc32);
        }
        BinaryWriter bw = new BinaryWriter(output);
        byte[] payloadBytes = payload.build().toByteArray();
        bw.writeInt(1911953360);
        bw.writeInt(payloadBytes.length);
        bw.write(payloadBytes);
        byte[] metadataBytes = metadata.build().toByteArray();
        bw.writeInt(524817086);
        bw.writeInt(metadataBytes.length);
        bw.write(metadataBytes);
        bw.writeInt(461486103);
        bw.writeInt(0);
        bw.writeInt(851711403);
        bw.close();
    }

    @JvmStatic
    @NotNull
    public static final DepotManifest deserialize(@NotNull InputStream stream) {
        return Companion.deserialize(stream);
    }

    @JvmStatic
    @NotNull
    public static final DepotManifest deserialize(@NotNull byte[] data) {
        return Companion.deserialize(data);
    }

    @JvmStatic
    @Nullable
    public static final DepotManifest loadFromFile(@NotNull String filename) {
        return Companion.loadFromFile(filename);
    }

    static {
        Logger logger = LogManager.getLogger(DepotManifest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DepotManifest.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lin/dragonbra/javasteam/types/DepotManifest$Companion;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "PROTOBUF_PAYLOAD_MAGIC", "", "PROTOBUF_METADATA_MAGIC", "PROTOBUF_SIGNATURE_MAGIC", "PROTOBUF_ENDOFMANIFEST_MAGIC", "deserialize", "Lin/dragonbra/javasteam/types/DepotManifest;", "stream", "Ljava/io/InputStream;", "data", "", "loadFromFile", "filename", "", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DepotManifest deserialize(@NotNull InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            DepotManifest manifest = new DepotManifest();
            manifest.internalDeserialize(stream);
            return manifest;
        }

        @JvmStatic
        @NotNull
        public final DepotManifest deserialize(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            MemoryStream ms = new MemoryStream(data);
            DepotManifest manifest = this.deserialize(ms);
            ms.close();
            return manifest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final DepotManifest loadFromFile(@NotNull String filename) {
            DepotManifest depotManifest2;
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            File file = new File(filename);
            if (!file.exists()) {
                return null;
            }
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream fileStream = (FileInputStream)closeable;
                boolean bl = false;
                depotManifest2 = Companion.deserialize(fileStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return depotManifest2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

