/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.types.KeyValue;
import in.dragonbra.javasteam.util.Passable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lin/dragonbra/javasteam/types/KVTextReader;", "Ljava/io/InputStreamReader;", "kv", "Lin/dragonbra/javasteam/types/KeyValue;", "inputStream", "Ljava/io/InputStream;", "<init>", "(Lin/dragonbra/javasteam/types/KeyValue;Ljava/io/InputStream;)V", "sb", "Ljava/lang/StringBuilder;", "peekedChar", "", "Ljava/lang/Integer;", "peek", "getPeek", "()I", "endOfStream", "", "getEndOfStream", "()Z", "read", "eatWhiteSpace", "", "eatCPPComment", "readLine", "readToken", "", "wasQuoted", "Lin/dragonbra/javasteam/util/Passable;", "wasConditional", "Companion", "javasteam"})
public final class KVTextReader
extends InputStreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder sb;
    @Nullable
    private Integer peekedChar;
    @JvmField
    @NotNull
    public static final Map<Character, Character> ESCAPED_MAPPING;

    public KVTextReader(@NotNull KeyValue kv, @NotNull InputStream inputStream) throws IllegalStateException, IOException {
        String s;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)kv, (String)"kv");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream, StandardCharsets.UTF_8);
        this.sb = new StringBuilder(128);
        Passable<Boolean> wasQuoted = new Passable<Boolean>(false);
        Passable<Boolean> wasConditional = new Passable<Boolean>(false);
        KeyValue currentKey = kv;
        while (!((charSequence = (CharSequence)(s = this.readToken(wasQuoted, wasConditional))) == null || charSequence.length() == 0)) {
            if (currentKey == null) {
                currentKey = new KeyValue(s, null, 2, null);
            } else {
                currentKey.setName(s);
            }
            s = this.readToken(wasQuoted, wasConditional);
            if (Intrinsics.areEqual((Object)wasConditional.getValue(), (Object)true)) {
                s = this.readToken(wasQuoted, wasConditional);
            }
            if (s == null || !StringsKt.startsWith$default((String)s, (String)"{", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)wasQuoted.getValue(), (Object)false)) {
                throw new IllegalStateException("LoadFromBuffer: missing {");
            }
            currentKey.recursiveLoadFromBuffer$javasteam(this);
            currentKey = null;
            if (!this.getEndOfStream()) continue;
            break;
        }
    }

    public final int getPeek() {
        if (this.peekedChar == null) {
            this.peekedChar = this.read();
        }
        Integer n = this.peekedChar;
        return n != null ? n : -1;
    }

    public final boolean getEndOfStream() {
        boolean bl;
        try {
            bl = this.getPeek() == -1;
        }
        catch (IOException iOException) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int read() {
        if (this.peekedChar != null) {
            Integer n = this.peekedChar;
            Intrinsics.checkNotNull((Object)n);
            int result = n;
            this.peekedChar = null;
            return result;
        }
        return super.read();
    }

    private final void eatWhiteSpace() throws IOException {
        while (!this.getEndOfStream() && CharsKt.isWhitespace((char)((char)this.getPeek()))) {
            this.read();
        }
    }

    private final boolean eatCPPComment() throws IOException {
        if (!this.getEndOfStream()) {
            char next = (char)this.getPeek();
            if (next == '/') {
                this.readLine();
                return true;
            }
            return false;
        }
        return false;
    }

    private final void readLine() throws IOException {
        char c = '\u0000';
        while ((c = (char)this.read()) != '\n' && !this.getEndOfStream()) {
        }
    }

    @Nullable
    public final String readToken(@NotNull Passable<Boolean> wasQuoted, @NotNull Passable<Boolean> wasConditional) throws IOException {
        Intrinsics.checkNotNullParameter(wasQuoted, (String)"wasQuoted");
        Intrinsics.checkNotNullParameter(wasConditional, (String)"wasConditional");
        wasQuoted.setValue(false);
        wasConditional.setValue(false);
        do {
            this.eatWhiteSpace();
            if (!this.getEndOfStream()) continue;
            return null;
        } while (this.eatCPPComment());
        if (this.getEndOfStream()) {
            return null;
        }
        char next = (char)this.getPeek();
        if (next == '\"') {
            wasQuoted.setValue(true);
            this.read();
            StringsKt.clear((StringBuilder)this.sb);
            while (!this.getEndOfStream()) {
                if ((char)this.getPeek() == '\\') {
                    this.read();
                    char escapedChar = (char)this.read();
                    Character c = ESCAPED_MAPPING.get(Character.valueOf(escapedChar));
                    char replacedChar = c != null ? c.charValue() : escapedChar;
                    this.sb.append(replacedChar);
                    continue;
                }
                if ((char)this.getPeek() == '\"') break;
                this.sb.append((char)this.read());
            }
            this.read();
            return this.sb.toString();
        }
        switch (next) {
            case '{': 
            case '}': {
                this.read();
                return String.valueOf(next);
            }
        }
        boolean bConditionalStart = false;
        boolean count = false;
        StringsKt.clear((StringBuilder)this.sb);
        block8: while (!this.getEndOfStream()) {
            next = (char)this.getPeek();
            switch (next) {
                case '\"': 
                case '{': 
                case '}': {
                    break block8;
                }
                default: {
                    if (next == '[') {
                        bConditionalStart = true;
                    }
                    if (next == ']' && bConditionalStart) {
                        wasConditional.setValue(true);
                    }
                    if (CharsKt.isWhitespace((char)next)) break block8;
                    this.sb.append(next);
                    this.read();
                    continue block8;
                }
            }
        }
        return this.sb.toString();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('\\'), (Object)Character.valueOf('\\')), TuplesKt.to((Object)Character.valueOf('n'), (Object)Character.valueOf('\n')), TuplesKt.to((Object)Character.valueOf('r'), (Object)Character.valueOf('\r')), TuplesKt.to((Object)Character.valueOf('t'), (Object)Character.valueOf('\t'))};
        ESCAPED_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/types/KVTextReader$Companion;", "", "<init>", "()V", "ESCAPED_MAPPING", "", "", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

