/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.types;

import in.dragonbra.javasteam.enums.EDepotFileFlag;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 F2\u00020\u0001:\u0002FGB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0000\u00a2\u0006\u0002\bER\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0007\"\u0004\b3\u0010\tR\u001a\u00104\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0007\"\u0004\b6\u0010\tR\u001a\u00107\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0007\"\u0004\b9\u0010\tR \u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006H"}, d2={"Lin/dragonbra/javasteam/types/Steam3Manifest;", "", "<init>", "()V", "magic", "", "getMagic", "()I", "setMagic", "(I)V", "version", "getVersion", "setVersion", "depotID", "getDepotID", "setDepotID", "manifestGID", "", "getManifestGID", "()J", "setManifestGID", "(J)V", "creationTime", "Ljava/util/Date;", "getCreationTime", "()Ljava/util/Date;", "setCreationTime", "(Ljava/util/Date;)V", "areFileNamesEncrypted", "", "getAreFileNamesEncrypted", "()Z", "setAreFileNamesEncrypted", "(Z)V", "totalUncompressedSize", "getTotalUncompressedSize", "setTotalUncompressedSize", "totalCompressedSize", "getTotalCompressedSize", "setTotalCompressedSize", "chunkCount", "getChunkCount", "setChunkCount", "fileEntryCount", "getFileEntryCount", "setFileEntryCount", "fileMappingSize", "getFileMappingSize", "setFileMappingSize", "encryptedCRC", "getEncryptedCRC", "setEncryptedCRC", "decryptedCRC", "getDecryptedCRC", "setDecryptedCRC", "flags", "getFlags", "setFlags", "mapping", "", "Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping;", "getMapping", "()Ljava/util/List;", "setMapping", "(Ljava/util/List;)V", "deserialize", "", "ds", "Lin/dragonbra/javasteam/util/stream/BinaryReader;", "deserialize$javasteam", "Companion", "FileMapping", "javasteam"})
public final class Steam3Manifest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int magic;
    private int version;
    private int depotID;
    private long manifestGID;
    @NotNull
    private Date creationTime = new Date();
    private boolean areFileNamesEncrypted;
    private long totalUncompressedSize;
    private long totalCompressedSize;
    private int chunkCount;
    private int fileEntryCount;
    private int fileMappingSize;
    private int encryptedCRC;
    private int decryptedCRC;
    private int flags;
    @NotNull
    private List<FileMapping> mapping = new ArrayList();
    public static final int MAGIC = 372545409;
    private static final int CURRENT_VERSION = 4;

    public final int getMagic() {
        return this.magic;
    }

    public final void setMagic(int n) {
        this.magic = n;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    public final int getDepotID() {
        return this.depotID;
    }

    public final void setDepotID(int n) {
        this.depotID = n;
    }

    public final long getManifestGID() {
        return this.manifestGID;
    }

    public final void setManifestGID(long l) {
        this.manifestGID = l;
    }

    @NotNull
    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final void setCreationTime(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"<set-?>");
        this.creationTime = date;
    }

    public final boolean getAreFileNamesEncrypted() {
        return this.areFileNamesEncrypted;
    }

    public final void setAreFileNamesEncrypted(boolean bl) {
        this.areFileNamesEncrypted = bl;
    }

    public final long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    public final void setTotalUncompressedSize(long l) {
        this.totalUncompressedSize = l;
    }

    public final long getTotalCompressedSize() {
        return this.totalCompressedSize;
    }

    public final void setTotalCompressedSize(long l) {
        this.totalCompressedSize = l;
    }

    public final int getChunkCount() {
        return this.chunkCount;
    }

    public final void setChunkCount(int n) {
        this.chunkCount = n;
    }

    public final int getFileEntryCount() {
        return this.fileEntryCount;
    }

    public final void setFileEntryCount(int n) {
        this.fileEntryCount = n;
    }

    public final int getFileMappingSize() {
        return this.fileMappingSize;
    }

    public final void setFileMappingSize(int n) {
        this.fileMappingSize = n;
    }

    public final int getEncryptedCRC() {
        return this.encryptedCRC;
    }

    public final void setEncryptedCRC(int n) {
        this.encryptedCRC = n;
    }

    public final int getDecryptedCRC() {
        return this.decryptedCRC;
    }

    public final void setDecryptedCRC(int n) {
        this.decryptedCRC = n;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int n) {
        this.flags = n;
    }

    @NotNull
    public final List<FileMapping> getMapping() {
        return this.mapping;
    }

    public final void setMapping(@NotNull List<FileMapping> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mapping = list;
    }

    public final void deserialize$javasteam(@NotNull BinaryReader ds) {
        long start;
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.version = ds.readInt();
        if (this.version != 4) {
            throw new NotImplementedError("Only version 4 is supported.");
        }
        this.depotID = ds.readInt();
        this.manifestGID = ds.readLong();
        this.creationTime = new Date((long)ds.readInt() * 1000L);
        this.areFileNamesEncrypted = ds.readInt() != 0;
        this.totalUncompressedSize = ds.readLong();
        this.totalCompressedSize = ds.readLong();
        this.chunkCount = ds.readInt();
        this.fileEntryCount = ds.readInt();
        this.fileMappingSize = ds.readInt();
        this.mapping = new ArrayList(this.fileMappingSize);
        this.encryptedCRC = ds.readInt();
        this.decryptedCRC = ds.readInt();
        this.flags = ds.readInt();
        for (int i2 = this.fileMappingSize; i2 > 0; i2 -= ds.getPosition() - (int)start) {
            start = ds.getPosition();
            FileMapping fileMapping = new FileMapping();
            fileMapping.deserialize$javasteam(ds);
            this.mapping.add(fileMapping);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lin/dragonbra/javasteam/types/Steam3Manifest$Companion;", "", "<init>", "()V", "MAGIC", "", "CURRENT_VERSION", "javasteam"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R,\u0010)\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+\u00a8\u00063"}, d2={"Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping;", "", "<init>", "()V", "fileName", "", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "totalSize", "", "getTotalSize", "()J", "setTotalSize", "(J)V", "flags", "Ljava/util/EnumSet;", "Lin/dragonbra/javasteam/enums/EDepotFileFlag;", "getFlags", "()Ljava/util/EnumSet;", "setFlags", "(Ljava/util/EnumSet;)V", "hashFileName", "", "getHashFileName", "()[B", "setHashFileName", "([B)V", "hashContent", "getHashContent", "setHashContent", "numChunks", "", "getNumChunks", "()I", "setNumChunks", "(I)V", "value", "", "Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping$Chunk;", "chunks", "getChunks", "()[Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping$Chunk;", "[Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping$Chunk;", "deserialize", "", "ds", "Lin/dragonbra/javasteam/util/stream/BinaryReader;", "deserialize$javasteam", "Chunk", "javasteam"})
    public static final class FileMapping {
        @Nullable
        private String fileName;
        private long totalSize;
        @NotNull
        private EnumSet<EDepotFileFlag> flags;
        @Nullable
        private byte[] hashFileName;
        @Nullable
        private byte[] hashContent;
        private int numChunks;
        @NotNull
        private Chunk[] chunks;

        public FileMapping() {
            EnumSet<EDepotFileFlag> enumSet = EnumSet.noneOf(EDepotFileFlag.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
            this.flags = enumSet;
            this.chunks = new Chunk[0];
        }

        @Nullable
        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(@Nullable String string) {
            this.fileName = string;
        }

        public final long getTotalSize() {
            return this.totalSize;
        }

        public final void setTotalSize(long l) {
            this.totalSize = l;
        }

        @NotNull
        public final EnumSet<EDepotFileFlag> getFlags() {
            return this.flags;
        }

        public final void setFlags(@NotNull EnumSet<EDepotFileFlag> enumSet) {
            Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
            this.flags = enumSet;
        }

        @Nullable
        public final byte[] getHashFileName() {
            return this.hashFileName;
        }

        public final void setHashFileName(@Nullable byte[] byArray) {
            this.hashFileName = byArray;
        }

        @Nullable
        public final byte[] getHashContent() {
            return this.hashContent;
        }

        public final void setHashContent(@Nullable byte[] byArray) {
            this.hashContent = byArray;
        }

        public final int getNumChunks() {
            return this.numChunks;
        }

        public final void setNumChunks(int n) {
            this.numChunks = n;
        }

        @NotNull
        public final Chunk[] getChunks() {
            return this.chunks;
        }

        public final void deserialize$javasteam(@NotNull BinaryReader ds) {
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            this.fileName = ds.readNullTermString(StandardCharsets.UTF_8);
            this.totalSize = ds.readLong();
            EnumSet<EDepotFileFlag> enumSet = EDepotFileFlag.from(ds.readInt());
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"from(...)");
            this.flags = enumSet;
            this.hashContent = ds.readBytes(20);
            this.hashFileName = ds.readBytes(20);
            this.numChunks = ds.readInt();
            int n = 0;
            int n2 = this.numChunks;
            Chunk[] chunkArray = new Chunk[n2];
            FileMapping fileMapping = this;
            while (n < n2) {
                int n3 = n++;
                chunkArray[n3] = new Chunk();
            }
            fileMapping.chunks = chunkArray;
            n2 = this.chunks.length;
            for (int x = 0; x < n2; ++x) {
                this.chunks[x].deserialize$javasteam(ds);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006!"}, d2={"Lin/dragonbra/javasteam/types/Steam3Manifest$FileMapping$Chunk;", "", "<init>", "()V", "chunkGID", "", "getChunkGID", "()[B", "setChunkGID", "([B)V", "checksum", "", "getChecksum", "()I", "setChecksum", "(I)V", "offset", "", "getOffset", "()J", "setOffset", "(J)V", "decompressedSize", "getDecompressedSize", "setDecompressedSize", "compressedSize", "getCompressedSize", "setCompressedSize", "deserialize", "", "ds", "Lin/dragonbra/javasteam/util/stream/BinaryReader;", "deserialize$javasteam", "javasteam"})
        public static final class Chunk {
            @Nullable
            private byte[] chunkGID;
            private int checksum;
            private long offset;
            private int decompressedSize;
            private int compressedSize;

            @Nullable
            public final byte[] getChunkGID() {
                return this.chunkGID;
            }

            public final void setChunkGID(@Nullable byte[] byArray) {
                this.chunkGID = byArray;
            }

            public final int getChecksum() {
                return this.checksum;
            }

            public final void setChecksum(int n) {
                this.checksum = n;
            }

            public final long getOffset() {
                return this.offset;
            }

            public final void setOffset(long l) {
                this.offset = l;
            }

            public final int getDecompressedSize() {
                return this.decompressedSize;
            }

            public final void setDecompressedSize(int n) {
                this.decompressedSize = n;
            }

            public final int getCompressedSize() {
                return this.compressedSize;
            }

            public final void setCompressedSize(int n) {
                this.compressedSize = n;
            }

            public final void deserialize$javasteam(@NotNull BinaryReader ds) {
                Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                this.chunkGID = ds.readBytes(20);
                this.checksum = ds.readInt();
                this.offset = ds.readLong();
                this.decompressedSize = ds.readInt();
                this.compressedSize = ds.readInt();
            }
        }
    }
}

