/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class HardwareUtils {
    private static String SERIAL_NUMBER;
    private static String MACHINE_NAME;

    public static byte[] getMachineID() {
        if (SERIAL_NUMBER != null) {
            return SERIAL_NUMBER.getBytes();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberWin();
        }
        if (SystemUtils.IS_OS_MAC) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberMac();
        }
        if (SystemUtils.IS_OS_LINUX) {
            SERIAL_NUMBER = HardwareUtils.getSerialNumberUnix();
        }
        if (SERIAL_NUMBER == null) {
            SERIAL_NUMBER = "JavaSteam-SerialNumber";
        }
        return SERIAL_NUMBER.getBytes();
    }

    private static String getSerialNumberWin() {
        Process process;
        String sn = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(new String[]{"wmic", "bios", "get", "serialnumber"});
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (Scanner sc = new Scanner(process.getInputStream());){
            while (sc.hasNext()) {
                String next = sc.next();
                if (!"SerialNumber".equals(next)) continue;
                sn = sc.next().trim();
                break;
            }
        }
        return sn;
    }

    private static String getSerialNumberMac() {
        Process process;
        String sn = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(new String[]{"/usr/sbin/system_profiler", "SPHardwareDataType"});
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String marker = "Serial Number";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains(marker)) continue;
                sn = line.split(":")[1].trim();
                break;
            }
        }
        catch (IOException e) {
            return null;
        }
        return sn;
    }

    private static String getSerialNumberUnix() {
        String sn = HardwareUtils.readDmidecode();
        if (sn == null) {
            sn = HardwareUtils.readLshal();
        }
        return sn;
    }

    private static BufferedReader read(String command) {
        Process process;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(command.split(" "));
        }
        catch (IOException e) {
            return null;
        }
        OutputStream os = process.getOutputStream();
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readDmidecode() {
        String sn = null;
        String marker = "Serial Number:";
        try (BufferedReader br = HardwareUtils.read("dmidecode -t system");){
            String line;
            if (br == null) {
                String string = null;
                return string;
            }
            do {
                if ((line = br.readLine()) == null) return sn;
            } while (!line.contains(marker));
            sn = line.split(marker)[1].trim();
            return sn;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLshal() {
        String sn = null;
        String marker = "system.hardware.serial =";
        try (BufferedReader br = HardwareUtils.read("lshal");){
            String line;
            if (br == null) {
                String string = null;
                return string;
            }
            do {
                if ((line = br.readLine()) == null) return sn;
            } while (!line.contains(marker));
            sn = line.split(marker)[1].replaceAll("\\(string\\)|(\\')", "").trim();
            return sn;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getMachineName() {
        return HardwareUtils.getMachineName(false);
    }

    public static String getMachineName(boolean addTag) {
        if (MACHINE_NAME != null) {
            return MACHINE_NAME;
        }
        MACHINE_NAME = SystemUtils.IS_OS_ANDROID ? HardwareUtils.getAndroidDeviceName() : HardwareUtils.getDeviceName();
        if (StringUtils.isBlank((CharSequence)MACHINE_NAME)) {
            MACHINE_NAME = "Unknown";
        }
        if (addTag || MACHINE_NAME.contains("Unknown")) {
            return MACHINE_NAME + " (JavaSteam)";
        }
        return MACHINE_NAME;
    }

    private static String getDeviceName() {
        String hostname = SystemUtils.getHostName();
        if (StringUtils.isBlank((CharSequence)hostname)) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = null;
            }
        }
        return hostname;
    }

    private static String getAndroidDeviceName() {
        String manufacturer = HardwareUtils.getAndroidSystemProperty("ro.product.manufacturer");
        String model = HardwareUtils.getAndroidSystemProperty("ro.product.model");
        if (manufacturer == null || model == null) {
            return "Android Device";
        }
        if (model.startsWith(manufacturer)) {
            return model;
        }
        return manufacturer + " " + model;
    }

    private static String getAndroidSystemProperty(String key) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class);
            return (String)get.invoke(null, key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

