/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.protobufs.steamclient.SteammessagesBase;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lin/dragonbra/javasteam/util/NetHelpers;", "", "<init>", "()V", "getIPAddress", "", "ipAddr", "Ljava/net/InetAddress;", "getLocalIP", "socket", "Ljava/net/Socket;", "datagramSocket", "Ljava/net/DatagramSocket;", "endpoint", "Lin/dragonbra/javasteam/protobufs/steamclient/SteammessagesBase$CMsgIPAddress;", "getMsgIPAddress", "obfuscatePrivateIP", "msgIpAddress", "tryParseIPEndPoint", "Ljava/net/InetSocketAddress;", "stringValue", "", "javasteam"})
@SourceDebugExtension(value={"SMAP\nNetHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetHelpers.kt\nin/dragonbra/javasteam/util/NetHelpers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public final class NetHelpers {
    @NotNull
    public static final NetHelpers INSTANCE = new NetHelpers();

    private NetHelpers() {
    }

    @JvmStatic
    public static final int getIPAddress(@NotNull InetAddress ipAddr) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)ipAddr, (String)"ipAddr");
        if (!(ipAddr.getAddress().length == 4)) {
            boolean bl = false;
            String string = "only works with IPv4 addresses.";
            throw new IllegalArgumentException(string.toString());
        }
        return ByteBuffer.wrap(ipAddr.getAddress()).getInt();
    }

    @JvmStatic
    @Nullable
    public static final InetAddress getLocalIP(@NotNull Socket socket) throws Exception {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        return NetHelpers.getLocalIP(socket.getLocalAddress());
    }

    @JvmStatic
    @Nullable
    public static final InetAddress getLocalIP(@NotNull DatagramSocket datagramSocket) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)datagramSocket, (String)"datagramSocket");
        return NetHelpers.getLocalIP(datagramSocket.getLocalAddress());
    }

    @JvmStatic
    @Nullable
    public static final InetAddress getLocalIP(@Nullable InetAddress endpoint) {
        if (endpoint == null || Arrays.equals(endpoint.getAddress(), InetAddress.getByName("0.0.0.0").getAddress())) {
            return null;
        }
        return endpoint;
    }

    @JvmStatic
    @NotNull
    public static final InetAddress getIPAddress(int ipAddr) {
        byte[] byArray = new byte[]{(byte)(ipAddr >> 24 & 0xFF), (byte)(ipAddr >> 16 & 0xFF), (byte)(ipAddr >> 8 & 0xFF), (byte)(ipAddr & 0xFF)};
        byte[] result = byArray;
        InetAddress inetAddress = InetAddress.getByAddress(result);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(...)");
        return inetAddress;
    }

    @JvmStatic
    @NotNull
    public static final InetAddress getIPAddress(@NotNull SteammessagesBase.CMsgIPAddress ipAddr) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)ipAddr, (String)"ipAddr");
        if (ipAddr.hasV6()) {
            InetAddress inetAddress2 = InetAddress.getByAddress(ipAddr.getV6().toByteArray());
            Intrinsics.checkNotNull((Object)inetAddress2);
            inetAddress = inetAddress2;
        } else {
            inetAddress = NetHelpers.getIPAddress(ipAddr.getV4());
        }
        return inetAddress;
    }

    @JvmStatic
    @NotNull
    public static final SteammessagesBase.CMsgIPAddress getMsgIPAddress(@NotNull InetAddress ipAddr) {
        Intrinsics.checkNotNullParameter((Object)ipAddr, (String)"ipAddr");
        SteammessagesBase.CMsgIPAddress.Builder msgIpAddress = SteammessagesBase.CMsgIPAddress.newBuilder();
        if (ipAddr instanceof Inet6Address) {
            msgIpAddress.setV6(ByteString.copyFrom((byte[])((Inet6Address)ipAddr).getAddress()));
        } else {
            msgIpAddress.setV4(NetHelpers.getIPAddress(ipAddr));
        }
        SteammessagesBase.CMsgIPAddress cMsgIPAddress = msgIpAddress.build();
        Intrinsics.checkNotNullExpressionValue((Object)cMsgIPAddress, (String)"build(...)");
        return cMsgIPAddress;
    }

    @JvmStatic
    @NotNull
    public static final SteammessagesBase.CMsgIPAddress obfuscatePrivateIP(@NotNull SteammessagesBase.CMsgIPAddress msgIpAddress) {
        Intrinsics.checkNotNullParameter((Object)msgIpAddress, (String)"msgIpAddress");
        SteammessagesBase.CMsgIPAddress.Builder localIp = msgIpAddress.toBuilder();
        if (localIp.hasV6()) {
            byte[] v6Bytes = msgIpAddress.getV6().toByteArray();
            int i2 = 0;
            int n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)15, (int)4);
            if (i2 <= n) {
                while (true) {
                    v6Bytes[i2] = (byte)(v6Bytes[i2] ^ 0xD);
                    v6Bytes[i2 + 1] = (byte)(v6Bytes[i2 + 1] ^ 0xF0);
                    v6Bytes[i2 + 2] = (byte)(v6Bytes[i2 + 2] ^ 0xAD);
                    v6Bytes[i2 + 3] = (byte)(v6Bytes[i2 + 3] ^ 0xBA);
                    if (i2 == n) break;
                    i2 += 4;
                }
            }
            localIp.setV6(ByteString.copyFrom((byte[])v6Bytes));
        } else {
            localIp.setV4(msgIpAddress.getV4() ^ 0xBAADF00D);
        }
        SteammessagesBase.CMsgIPAddress cMsgIPAddress = localIp.build();
        Intrinsics.checkNotNullExpressionValue((Object)cMsgIPAddress, (String)"build(...)");
        return cMsgIPAddress;
    }

    @JvmStatic
    @Nullable
    public static final InetSocketAddress tryParseIPEndPoint(@NotNull String stringValue) {
        Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
        try {
            InetSocketAddress inetSocketAddress;
            int split = StringsKt.lastIndexOf$default((CharSequence)stringValue, (char)':', (int)0, (boolean)false, (int)6, null);
            if (split == -1) {
                return null;
            }
            String string = stringValue.substring(0, split);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String ip = string;
            String string2 = stringValue.substring(split + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Integer n = StringsKt.toIntOrNull((String)string2);
            if (n == null) {
                return null;
            }
            int port = n;
            if (StringsKt.startsWith$default((String)ip, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)ip, (String)"]", (boolean)false, (int)2, null)) {
                String string3 = ip.substring(1, ip.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                ip = string3;
            }
            try {
                inetSocketAddress = new InetSocketAddress(ip, port);
            }
            catch (UnknownHostException e) {
                inetSocketAddress = null;
            }
            return inetSocketAddress;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

