/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.compat.InputStreamCompatKt;
import in.dragonbra.javasteam.util.crypto.CryptoHelper;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import in.dragonbra.javasteam.util.stream.BinaryReader;
import in.dragonbra.javasteam.util.stream.BinaryWriter;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lin/dragonbra/javasteam/util/VZipUtil;", "", "<init>", "()V", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "VZIP_HEADER", "", "VZIP_FOOTER", "HEADER_LENGTH", "", "FOOTER_LENGTH", "VERSION", "", "decompress", "ms", "Lin/dragonbra/javasteam/util/stream/MemoryStream;", "destination", "", "verifyChecksum", "", "compress", "buffer", "javasteam"})
public final class VZipUtil {
    @NotNull
    public static final VZipUtil INSTANCE = new VZipUtil();
    private static final Logger logger = LogManager.getLogger(VZipUtil.class);
    private static final short VZIP_HEADER = 23126;
    private static final short VZIP_FOOTER = 30330;
    private static final int HEADER_LENGTH = 7;
    private static final int FOOTER_LENGTH = 10;
    private static final byte VERSION = 97;

    private VZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int decompress(@NotNull MemoryStream ms, @NotNull byte[] destination, boolean verifyChecksum) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            Closeable closeable = new BinaryReader(ms);
            Throwable throwable = null;
            try {
                int n;
                BinaryReader reader = (BinaryReader)closeable;
                boolean bl = false;
                if (reader.readShort() != 23126) {
                    throw new IllegalArgumentException("Expecting VZipHeader at start of stream");
                }
                if (reader.readByte() != 97) {
                    throw new IllegalArgumentException("Expecting VZip version 'a'");
                }
                reader.readInt();
                byte propertyBits = reader.readByte();
                int dictionarySize = reader.readInt();
                long compressedBytesOffset = ms.getPosition();
                ms.seek(-10L, SeekOrigin.END);
                int outputCrc = reader.readInt();
                int sizeDecompressed = reader.readInt();
                if (reader.readShort() != 30330) {
                    throw new IllegalArgumentException("Expecting VZipFooter at end of stream");
                }
                if (destination.length < sizeDecompressed) {
                    throw new IllegalArgumentException("The destination buffer is smaller than the decompressed data size.");
                }
                ms.setPosition(compressedBytesOffset);
                byte[] windowBuffer = new byte[Math.max(4096, dictionarySize)];
                Closeable closeable2 = (Closeable)new LZMAInputStream((InputStream)ms, (long)sizeDecompressed, propertyBits, dictionarySize, windowBuffer);
                Throwable throwable2 = null;
                try {
                    LZMAInputStream lzmaInput = (LZMAInputStream)closeable2;
                    boolean bl2 = false;
                    n = InputStreamCompatKt.readNBytesCompat((InputStream)lzmaInput, destination, 0, sizeDecompressed);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                int bytesRead2 = n;
                if (verifyChecksum && (int)Utils.crc32(destination) != outputCrc) {
                    throw new DataFormatException("CRC does not match decompressed data. VZip data may be corrupted.");
                }
                int n2 = bytesRead2;
                return n2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.error("Missing implementation of org.tukaani:xz");
            throw e;
        }
        catch (ClassNotFoundException e) {
            logger.error("Missing implementation of org.tukaani:xz");
            throw e;
        }
    }

    public static /* synthetic */ int decompress$default(MemoryStream memoryStream, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return VZipUtil.decompress(memoryStream, byArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final byte[] compress(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray;
                ByteArrayOutputStream ms = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new BinaryWriter(ms);
                Throwable throwable2 = null;
                try {
                    Object object;
                    BinaryWriter writer = (BinaryWriter)closeable2;
                    boolean bl2 = false;
                    byte[] crc = CryptoHelper.crcHash(buffer);
                    writer.writeShort((short)23126);
                    writer.writeByte((byte)97);
                    writer.write(crc);
                    LZMA2Options $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242 = object = new LZMA2Options();
                    boolean bl3 = false;
                    $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242.setDictSize(0x800000);
                    $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242.setPreset(2);
                    $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242.setNiceLen(128);
                    $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242.setMatchFinder(20);
                    $this$compress_u24lambda_u245_u24lambda_u244_u24lambda_u242.setMode(2);
                    LZMA2Options options = object;
                    object = (Closeable)new LZMAOutputStream((OutputStream)ms, options, false);
                    Throwable throwable3 = null;
                    try {
                        LZMAOutputStream lzmaStream = (LZMAOutputStream)object;
                        boolean bl4 = false;
                        lzmaStream.write(buffer);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
                    }
                    writer.write(crc);
                    writer.writeInt(buffer.length);
                    writer.writeShort((short)30330);
                    byte[] byArray2 = ms.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                    byArray = byArray2;
                }
                catch (Throwable throwable5) {
                    try {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                            throw throwable6;
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                byte[] byArray3 = byArray;
                return byArray3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoClassDefFoundError e) {
            logger.error("Missing implementation of org.tukaani:xz");
            throw e;
        }
        catch (ClassNotFoundException e) {
            logger.error("Missing implementation of org.tukaani:xz");
            throw e;
        }
    }
}

