/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import com.github.luben.zstd.Zstd;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lin/dragonbra/javasteam/util/VZstdUtil;", "", "<init>", "()V", "VZSTD_HEADER", "", "logger", "Lin/dragonbra/javasteam/util/log/Logger;", "kotlin.jvm.PlatformType", "decompress", "buffer", "", "destination", "verifyChecksum", "", "javasteam"})
public final class VZstdUtil {
    @NotNull
    public static final VZstdUtil INSTANCE = new VZstdUtil();
    private static final int VZSTD_HEADER = 1633309526;
    private static final Logger logger = LogManager.getLogger(VZstdUtil.class);

    private VZstdUtil() {
    }

    @JvmStatic
    @JvmOverloads
    public static final int decompress(@NotNull byte[] buffer, @NotNull byte[] destination, boolean verifyChecksum) throws IOException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
        int header = byteBuffer.getInt(0);
        if (header != 1633309526) {
            throw new IOException("Expecting VZstdHeader at start of stream");
        }
        int crc32 = byteBuffer.getInt(4);
        int crc32Footer = byteBuffer.getInt(buffer.length - 15);
        int sizeDecompressed = byteBuffer.getInt(buffer.length - 11);
        if (crc32 == crc32Footer) {
            logger.debug("CRC32 appears to be written twice in the data");
        }
        if (buffer[buffer.length - 3] != 122 || buffer[buffer.length - 2] != 115 || buffer[buffer.length - 1] != 118) {
            throw new IOException("Expecting VZstdFooter at end of stream");
        }
        if (destination.length < sizeDecompressed) {
            throw new IllegalArgumentException("The destination buffer is smaller than the decompressed data size.");
        }
        byte[] compressedData = ArraysKt.copyOfRange((byte[])buffer, (int)8, (int)(buffer.length - 15));
        try {
            long bytesDecompressed = Zstd.decompress((byte[])destination, (byte[])compressedData);
            if (bytesDecompressed != (long)sizeDecompressed) {
                throw new IOException("Failed to decompress Zstd (expected " + sizeDecompressed + " bytes, got " + bytesDecompressed + ").");
            }
            if (verifyChecksum) {
                CRC32 crc = new CRC32();
                crc.update(destination, 0, sizeDecompressed);
                int calculatedCrc = (int)crc.getValue();
                if (calculatedCrc != crc32Footer) {
                    throw new IOException("CRC does not match decompressed data. VZstd data may be corrupted.");
                }
            }
            return sizeDecompressed;
        }
        catch (NoClassDefFoundError e) {
            logger.error("Missing implementation of com.github.luben:zstd-jni");
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to decompress Zstd data: " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ int decompress$default(byte[] byArray, byte[] byArray2, boolean bl, int n, Object object) throws IOException, IllegalArgumentException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return VZstdUtil.decompress(byArray, byArray2, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final int decompress(@NotNull byte[] buffer, @NotNull byte[] destination) throws IOException, IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return VZstdUtil.decompress$default(buffer, destination, false, 4, null);
    }
}

