/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import java.nio.charset.StandardCharsets;

public class WebHelpers {
    private static boolean isUrlSafeChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.' || ch == '_';
    }

    public static String urlEncode(String input) {
        return WebHelpers.urlEncode(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String urlEncode(byte[] input) {
        StringBuilder encoded = new StringBuilder(input.length * 2);
        for (byte i2 : input) {
            char inch = (char)i2;
            if (WebHelpers.isUrlSafeChar(inch)) {
                encoded.append(inch);
                continue;
            }
            if (inch == ' ') {
                encoded.append('+');
                continue;
            }
            encoded.append(String.format("%%%02X", i2));
        }
        return encoded.toString();
    }
}

