/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util;

import in.dragonbra.javasteam.util.Utils;
import in.dragonbra.javasteam.util.compat.InputStreamCompatKt;
import in.dragonbra.javasteam.util.stream.MemoryStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lin/dragonbra/javasteam/util/ZipUtil;", "", "<init>", "()V", "decompress", "", "ms", "Lin/dragonbra/javasteam/util/stream/MemoryStream;", "destination", "", "verifyChecksum", "", "javasteam"})
public final class ZipUtil {
    @NotNull
    public static final ZipUtil INSTANCE = new ZipUtil();

    private ZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final int decompress(@NotNull MemoryStream ms, @NotNull byte[] destination, boolean verifyChecksum) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Closeable closeable = new ZipInputStream((InputStream)ms, Charsets.UTF_8);
        Throwable throwable = null;
        try {
            ZipInputStream zip = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = zip.getNextEntry();
            if (zipEntry == null) {
                throw new IllegalArgumentException("Did not find any zip entries in the given stream");
            }
            ZipEntry entry = zipEntry;
            int sizeDecompressed = (int)entry.getSize();
            if (destination.length < sizeDecompressed) {
                throw new IllegalArgumentException("The destination buffer is smaller than the decompressed data size.");
            }
            int bytesRead2 = InputStreamCompatKt.readNBytesCompat(zip, destination, 0, sizeDecompressed);
            if (zip.getNextEntry() != null) {
                throw new IllegalArgumentException("Given stream should only contain one zip entry");
            }
            if (verifyChecksum && Utils.crc32(ArraysKt.sliceArray((byte[])destination, (IntRange)RangesKt.until((int)0, (int)sizeDecompressed))) != entry.getCrc()) {
                throw new Exception("Checksum validation failed for decompressed file");
            }
            int n = bytesRead2;
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ int decompress$default(MemoryStream memoryStream, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ZipUtil.decompress(memoryStream, byArray, bl);
    }
}

