/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.compat;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0012\u0010\u0000\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"readNBytesCompat", "", "Ljava/io/InputStream;", "b", "", "off", "len", "javasteam"})
@SourceDebugExtension(value={"SMAP\nInputStreamCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamCompat.kt\nin/dragonbra/javasteam/util/compat/InputStreamCompatKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1#2:94\n1869#3,2:95\n*S KotlinDebug\n*F\n+ 1 InputStreamCompat.kt\nin/dragonbra/javasteam/util/compat/InputStreamCompatKt\n*L\n84#1:95,2\n*E\n"})
public final class InputStreamCompatKt {
    public static final int readNBytesCompat(@NotNull InputStream $this$readNBytesCompat, @NotNull byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        Intrinsics.checkNotNullParameter((Object)$this$readNBytesCompat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Objects.checkFromIndexSize(off, len, b.length);
        for (n = 0; n < len && (count = $this$readNBytesCompat.read(b, off + n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    @NotNull
    public static final byte[] readNBytesCompat(@NotNull InputStream $this$readNBytesCompat, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readNBytesCompat, (String)"<this>");
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        List bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = 0;
        remaining = len;
        int n = 0;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while (true) {
                int n2;
                int it = n2 = $this$readNBytesCompat.read(buf, nread, Math.min(buf.length - nread, remaining));
                boolean bl = false;
                n = it;
                if (n2 <= 0) break;
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList();
                ((ArrayList)bufs).add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            byte[] byArray;
            if (result == null) {
                return new byte[0];
            }
            if (result.length == total) {
                byArray = result;
            } else {
                byte[] byArray2 = Arrays.copyOf(result, total);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            }
            return byArray;
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        Iterable $this$forEach$iv = bufs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] b = (byte[])element$iv;
            boolean bl = false;
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }
}

