/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.crypto;

import in.dragonbra.javasteam.util.crypto.AsnParser;
import in.dragonbra.javasteam.util.crypto.BerDecodeException;
import in.dragonbra.javasteam.util.log.LogManager;
import in.dragonbra.javasteam.util.log.Logger;
import java.math.BigInteger;
import java.util.List;

public class AsnKeyParser {
    private static final Logger logger = LogManager.getLogger(AsnKeyParser.class);
    private final AsnParser _parser;

    AsnKeyParser(List<Byte> contents) {
        this._parser = new AsnParser(contents);
    }

    public static byte[] trimLeadingZero(byte[] values) {
        byte[] r;
        if (0 == values[0] && values.length > 1) {
            r = new byte[values.length - 1];
            System.arraycopy(values, 1, r, 0, values.length - 1);
        } else {
            r = new byte[values.length];
            System.arraycopy(values, 0, r, 0, values.length);
        }
        return r;
    }

    public static boolean equalOid(byte[] first, byte[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i2 = 0; i2 < first.length; ++i2) {
            if (first[i2] == second[i2]) continue;
            return false;
        }
        return true;
    }

    public BigInteger[] parseRSAPublicKey() throws BerDecodeException {
        byte[] oid;
        BigInteger[] parameters = new BigInteger[2];
        int position = this._parser.currentPosition();
        int length = this._parser.nextSequence();
        if (length != this._parser.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Sequence Size. Specified: %d, Remaining: %d", length, this._parser.remainingBytes()), position);
        }
        position = this._parser.currentPosition();
        length = this._parser.nextSequence();
        if (length > this._parser.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect AlgorithmIdentifier Size. Specified: %d, Remaining: %d", length, this._parser.remainingBytes()), position);
        }
        position = this._parser.currentPosition();
        byte[] value = this._parser.nextOID();
        if (!AsnKeyParser.equalOid(value, oid = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1})) {
            throw new BerDecodeException("Expected OID 1.2.840.113549.1.1.1", position);
        }
        if (this._parser.isNextNull()) {
            this._parser.nextNull();
        } else {
            this._parser.next();
        }
        position = this._parser.currentPosition();
        length = this._parser.nextBitString();
        if (length > this._parser.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect PublicKey Size. Specified: %d, Remaining: %d", length, this._parser.remainingBytes()), position);
        }
        position = this._parser.currentPosition();
        length = this._parser.nextSequence();
        if (length < this._parser.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect RSAPublicKey Size. Specified: %d, Remaining: %d", length, this._parser.remainingBytes()), position);
        }
        parameters[0] = new BigInteger(1, AsnKeyParser.trimLeadingZero(this._parser.nextInteger()));
        parameters[1] = new BigInteger(1, AsnKeyParser.trimLeadingZero(this._parser.nextInteger()));
        assert (0 == this._parser.remainingBytes());
        return parameters;
    }
}

