/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.crypto;

import in.dragonbra.javasteam.util.crypto.BerDecodeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class AsnParser {
    private final int initialCount;
    private final List<Byte> octets = new ArrayList<Byte>();

    public AsnParser(Collection<Byte> values) {
        this.octets.addAll(values);
        this.initialCount = this.octets.size();
    }

    public int currentPosition() {
        return this.initialCount - this.octets.size();
    }

    public int remainingBytes() {
        return this.octets.size();
    }

    int getLength() throws BerDecodeException {
        int length = 0;
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (b == (b & 0x7F)) {
            return b;
        }
        int i2 = b & 0x7F;
        if (i2 > 4) {
            throw new BerDecodeException(String.format("Invalid Length Encoding. Length uses %d _octets", i2), position);
        }
        while (0 != i2--) {
            length <<= 8;
            length |= this.getNextOctet();
        }
        return length & 0xFF;
    }

    public byte[] next() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        int length = this.getLength();
        if (length > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Size. Specified: %d, Remaining: %d", length, this.remainingBytes()), position);
        }
        return this.getOctets(length);
    }

    public byte getNextOctet() throws BerDecodeException {
        int position = this.currentPosition();
        if (0 == this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect size. Specified: %d, Remaining: %d", 1, this.remainingBytes()), position);
        }
        return this.getOctets(1)[0];
    }

    private byte[] getOctets(int octetCount) throws BerDecodeException {
        int position = this.currentPosition();
        if (octetCount > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect size. Specified: %d, Remaining: %d", octetCount, this.remainingBytes()), position);
        }
        byte[] values = new byte[octetCount];
        for (int i2 = 0; i2 < octetCount; ++i2) {
            values[i2] = this.octets.remove(0);
        }
        return values;
    }

    public boolean isNextNull() {
        return 5 == this.octets.get(0);
    }

    public int nextNull() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (5 != b) {
            throw new BerDecodeException(String.format("Expected Null. Specified Identifier: %d", b), position);
        }
        b = this.getNextOctet();
        if (0 != b) {
            throw new BerDecodeException(String.format("Null has non-zero size. Size: %d", b), position);
        }
        return 0;
    }

    public boolean isNextSequence() {
        return 48 == this.octets.get(0);
    }

    public int nextSequence() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (48 != b) {
            throw new BerDecodeException(String.format("Expected Sequence. Specified Identifier: %d", b), position);
        }
        int length = this.getLength();
        if (length > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Sequence Size. Specified: %d, Remaining: %d", length, this.remainingBytes()), position);
        }
        return length;
    }

    public boolean isNextOctetString() {
        return 4 == this.octets.get(0);
    }

    public int nextOctetString() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (4 != b) {
            throw new BerDecodeException(String.format("Expected Octet String.Specified Identifier: %d", b), position);
        }
        int length = this.getLength();
        if (length > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Octet String Size. Specified: %d, Remaining: %d", length, this.remainingBytes()), position);
        }
        return length;
    }

    public boolean isNextBitString() {
        return 3 == this.octets.get(0);
    }

    public int nextBitString() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (3 != b) {
            throw new BerDecodeException(String.format("Expected Bit String. Specified Identifier: %d", b), position);
        }
        int length = this.getLength();
        b = this.octets.get(0);
        this.octets.remove(0);
        --length;
        if (0 != b) {
            throw new BerDecodeException("The first octet of BitString must be 0", position);
        }
        return length;
    }

    public boolean isNextInteger() {
        return 2 == this.octets.get(0);
    }

    public byte[] nextInteger() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (2 != b) {
            throw new BerDecodeException(String.format("Expected Integer. Specified Identifier: %d", b), position);
        }
        int length = this.getLength();
        if (length > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Integer Size. Specified: %d, Remaining: %d", length, this.remainingBytes()), position);
        }
        return this.getOctets(length);
    }

    public byte[] nextOID() throws BerDecodeException {
        int position = this.currentPosition();
        byte b = this.getNextOctet();
        if (6 != b) {
            throw new BerDecodeException(String.format("Expected Object Identifier. Specified Identifier: %d", b), position);
        }
        int length = this.getLength();
        if (length > this.remainingBytes()) {
            throw new BerDecodeException(String.format("Incorrect Object Identifier Size. Specified: %d, Remaining: %d", length, this.remainingBytes()), position);
        }
        byte[] values = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            values[i2] = this.octets.remove(0);
        }
        return values;
    }
}

