/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.log;

import in.dragonbra.javasteam.util.log.LogListener;
import in.dragonbra.javasteam.util.log.LogManager;

public class Logger {
    private final Class<?> clazz;

    Logger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class is null");
        }
        this.clazz = clazz;
    }

    public void debug(Throwable throwable) {
        this.debug(null, throwable);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable throwable) {
        for (LogListener listener : LogManager.LOG_LISTENERS) {
            if (listener == null) continue;
            listener.onLog(this.clazz, message, throwable);
        }
    }

    public void error(Throwable throwable) {
        this.error(null, throwable);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable throwable) {
        for (LogListener listener : LogManager.LOG_LISTENERS) {
            if (listener == null) continue;
            listener.onError(this.clazz, message, throwable);
        }
    }
}

