/*
 * Decompiled with CFR 0.152.
 */
package in.dragonbra.javasteam.util.stream;

import com.google.protobuf.ByteString;
import in.dragonbra.javasteam.util.stream.SeekOrigin;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class MemoryStream
extends InputStream
implements Closeable {
    private byte[] buffer;
    private int capacity;
    private int length;
    private final int origin;
    private int position;
    private final boolean writable;
    private final boolean expandable;
    private final boolean bufferVisible;
    private int mark;

    public MemoryStream() {
        this(0);
    }

    public MemoryStream(int capacity) {
        this.buffer = new byte[capacity];
        this.capacity = capacity;
        this.length = 0;
        this.origin = 0;
        this.position = 0;
        this.writable = true;
        this.expandable = true;
        this.bufferVisible = true;
    }

    public MemoryStream(ByteString byteString) {
        this(byteString.toByteArray(), true);
    }

    public MemoryStream(byte[] buffer) {
        this(buffer, true);
    }

    public MemoryStream(byte[] buffer, boolean writable) {
        this.buffer = buffer;
        this.capacity = buffer.length;
        this.length = buffer.length;
        this.origin = 0;
        this.position = 0;
        this.writable = writable;
        this.expandable = true;
        this.bufferVisible = false;
    }

    public MemoryStream(byte[] buffer, int index, int count) {
        this(buffer, index, count, true, false);
    }

    public MemoryStream(byte[] buffer, int index, int count, boolean writable) {
        this(buffer, index, count, writable, false);
    }

    public MemoryStream(byte[] buffer, int index, int count, boolean writable, boolean publiclyVisible) {
        this.buffer = buffer;
        this.length = this.capacity = index + count;
        this.origin = index;
        this.position = index;
        this.writable = writable;
        this.bufferVisible = publiclyVisible;
        this.expandable = false;
    }

    @Override
    public synchronized int available() {
        return this.length - this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() {
        this.position = this.mark;
    }

    @Override
    public synchronized int read() {
        if (this.position >= this.length) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (this.position >= this.length || len == 0) {
            return 0;
        }
        if (this.position > this.length - len) {
            len = this.length - this.position;
        }
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        int previousPosition = this.position;
        long newPosition = this.seek(n, SeekOrigin.CURRENT);
        return newPosition - (long)previousPosition;
    }

    public byte[] getBuffer() {
        if (!this.bufferVisible) {
            throw new IllegalStateException("Cannot call getBuffer().");
        }
        return this.buffer;
    }

    public int getCapacity() {
        return this.capacity - this.origin;
    }

    public void setCapacity(int value) {
        if (!this.expandable) {
            throw new UnsupportedOperationException("Cannot expand this MemoryStream");
        }
        if (this.buffer != null && value == this.buffer.length) {
            return;
        }
        byte[] newBuffer = null;
        if (value > 0) {
            newBuffer = new byte[value];
            if (this.buffer != null) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
            }
        }
        this.buffer = newBuffer;
        this.capacity = value;
    }

    public long getLength() {
        return this.length - this.origin;
    }

    public void setLength(long value) {
        if (value < 0L) {
            throw new IndexOutOfBoundsException("MemoryStream length must be non-negative.");
        }
        if (!this.writable) {
            throw new UnsupportedOperationException("Cannot write to this stream.");
        }
        int newLength = (int)value + this.origin;
        boolean newArray = this.expand(newLength);
        if (!newArray && newLength > this.length) {
            this.clearBuffer(this.length, newLength);
        }
        this.length = newLength;
        if (this.position > this.length) {
            this.position = this.length;
        }
    }

    public long getPosition() {
        return this.position - this.origin;
    }

    public void setPosition(long value) {
        this.position = this.origin + (int)value;
    }

    public long seek(long offset, SeekOrigin loc) {
        int reference;
        switch (loc) {
            case BEGIN: {
                reference = this.origin;
                break;
            }
            case CURRENT: {
                reference = this.position;
                break;
            }
            case END: {
                reference = this.length;
                break;
            }
            default: {
                throw new IllegalArgumentException("loc");
            }
        }
        this.position = reference + (int)offset;
        return this.position;
    }

    public void write(byte[] buffer, int offset, int count) {
        boolean newArray;
        if (!this.writable) {
            throw new UnsupportedOperationException("Cannot write to this stream.");
        }
        int newPosition = this.position + count;
        if (newPosition > this.length && !(newArray = this.expand(newPosition)) && this.position > this.length) {
            this.clearBuffer(this.length, newPosition);
        }
        System.arraycopy(buffer, offset, this.buffer, this.position, count);
        this.position = newPosition;
        if (newPosition > this.length) {
            this.length = newPosition;
        }
    }

    public void writeByte(byte value) {
        if (!this.writable) {
            throw new UnsupportedOperationException("Cannot write to this stream.");
        }
        if (this.position >= this.length) {
            int newLength = this.position + 1;
            boolean newArray = this.expand(newLength);
            if (!newArray && this.position > this.length) {
                this.clearBuffer(this.length, this.position);
            }
            this.length = newLength;
        }
        this.buffer[this.position++] = value;
    }

    private void clearBuffer(int from, int to) {
        Arrays.fill(this.buffer, from, to, (byte)0);
    }

    private boolean expand(int newLength) {
        if (newLength > this.capacity) {
            int newCapacity = Math.max(256, newLength);
            newCapacity = Math.max(this.capacity * 2, newCapacity);
            this.setCapacity(newCapacity);
            return true;
        }
        return false;
    }

    public byte[] toByteArray() {
        byte[] ret = new byte[this.length];
        System.arraycopy(this.buffer, 0, ret, 0, this.length);
        return ret;
    }

    @Override
    public byte @NotNull [] readAllBytes() {
        return this.toByteArray();
    }

    public OutputStream asOutputStream() {
        return new OutputStreamWrapper(this);
    }

    private static class OutputStreamWrapper
    extends OutputStream {
        private final MemoryStream memoryStream;

        public OutputStreamWrapper(MemoryStream memoryStream) {
            this.memoryStream = memoryStream;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.memoryStream.write(b, off, len);
        }

        @Override
        public void write(int b) {
            this.memoryStream.writeByte((byte)b);
        }
    }
}

