/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import in.erail.glue.Glue;
import in.erail.glue.InstanceFactory;
import in.erail.glue.PropertiesRepository;
import in.erail.glue.ValueProxy;
import in.erail.glue.annotation.StartService;
import in.erail.glue.common.PropertyContext;
import in.erail.glue.common.Tuple;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.ComponentScopeType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;

public class ComponentRepository
implements Glue {
    private static final PropertiesRepository mPropertiesRepository;
    private static final Map<String, Object> mSingletonRepository;
    protected org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)ComponentRepository.class.getCanonicalName());

    protected synchronized Object resolve(String pPath, ListMultimap<String, ValueWithModifier> pProperties) {
        ArrayDeque<PropertyContext> propertyStack = new ArrayDeque<PropertyContext>();
        this.logger.debug(() -> "Component[" + pPath + "]:Loading");
        Tuple<Boolean, Object> instance = this.getInstance(pPath, pProperties);
        boolean isNewInstance = (Boolean)instance.value1;
        Object objInstance = instance.value2;
        this.logger.debug(() -> "Component[" + pPath + "]:Got instance isNewInstance[" + isNewInstance + "]");
        if (!isNewInstance || objInstance == null) {
            return objInstance;
        }
        this.logger.debug(() -> "Component[" + pPath + "]:Loading properties");
        this.loadPropertiesInStack(objInstance, pProperties, pPath, propertyStack);
        this.processPropertyStack(propertyStack);
        this.logger.debug(() -> "Component[" + pPath + "]:Loading Finished");
        return objInstance;
    }

    protected void processPropertyStack(Deque<PropertyContext> pPropertyStack) {
        try {
            while (!pPropertyStack.isEmpty()) {
                PropertyContext propCtx = pPropertyStack.pop();
                this.logger.debug(() -> "Component[" + propCtx.getComponentPath() + "]:Processing property " + propCtx.getMethod().getName());
                this.processProperty(propCtx, pPropertyStack);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            Logger.getLogger(ComponentRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void processProperty(PropertyContext pPropCtx, Deque<PropertyContext> pPropertyStack) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ValueProxy v = pPropCtx.getValue();
        if (v != null) {
            if (v.isDeferredValue() && !v.isDeferredComponentProcessed()) {
                this.logger.debug(() -> "Component[" + pPropCtx.getComponentPath() + "]: Property referes to another component. Processing " + v.getDeferredComponentPath());
                Tuple<Boolean, Object> instance = this.getInstance(v.getDeferredComponentPath(), ComponentRepository.getPropertiesCache().get(v.getDeferredComponentPath()));
                boolean isNewInstance = (Boolean)instance.value1;
                Object objInstance = instance.value2;
                v.setDeferredComponent(objInstance);
                v.setDeferredComponentProcessed(true);
                pPropertyStack.push(pPropCtx);
                if (isNewInstance && objInstance != null) {
                    this.loadPropertiesInStack(objInstance, ComponentRepository.getPropertiesCache().get(v.getDeferredComponentPath()), v.getDeferredComponentPath(), pPropertyStack);
                }
                return;
            }
            v.process();
            this.logger.debug(() -> "Component[" + pPropCtx.getComponentPath() + "]: Property :" + pPropCtx.getMethod().getName() + ", Value derived :" + v.getValue());
            pPropCtx.getMethod().invoke(pPropCtx.getInstance(), v.getValue());
        } else {
            this.logger.debug(() -> "Component[" + pPropCtx.getComponentPath() + "]: Invoking Property without arguments :" + pPropCtx.getMethod().getName());
            pPropCtx.getMethod().invoke(pPropCtx.getInstance(), new Object[0]);
        }
    }

    protected void loadPropertiesInStack(Object pInstance, ListMultimap<String, ValueWithModifier> pProperties, String pComponentPath, Deque<PropertyContext> pPropertyStack) {
        Method startupmethod = Util.getMethodWithAnnotation(pInstance.getClass(), StartService.class);
        if (startupmethod != null) {
            PropertyContext propCtx = new PropertyContext();
            propCtx.setInstance(pInstance);
            propCtx.setMethod(startupmethod);
            propCtx.setValue(null);
            propCtx.setComponentPath(pComponentPath);
            this.logger.debug(() -> "Component[" + pComponentPath + "]:Found start service method:" + propCtx.getMethod().getName());
            pPropertyStack.push(propCtx);
        }
        pProperties.asMap().entrySet().stream().filter(t -> !((String)t.getKey()).startsWith("$")).filter(t -> Util.getMethod(pInstance.getClass(), Util.buildSetPropertyName((String)t.getKey())) != null).map(entry -> {
            PropertyContext propCtx = new PropertyContext();
            propCtx.setInstance(pInstance);
            propCtx.setMethod(Util.getMethod(pInstance.getClass(), Util.buildSetPropertyName((String)entry.getKey())));
            ValueProxy v = new ValueProxy(Util.getMethodFirstArgumentClass(propCtx.getMethod()), (Collection)entry.getValue(), pComponentPath);
            propCtx.setValue(v);
            propCtx.setComponentPath(pComponentPath);
            return propCtx;
        }).forEachOrdered(propertyCtx -> {
            this.logger.debug(() -> "Component[" + pComponentPath + "]:Ready to process:" + propertyCtx.getMethod().getName() + ", Value=" + propertyCtx.getValue());
            pPropertyStack.push((PropertyContext)propertyCtx);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Tuple<Boolean, Object> getInstance(String pPath, ListMultimap<String, ValueWithModifier> pProperties) {
        Tuple<Boolean, Object> result;
        Preconditions.checkNotNull(pProperties, (String)"pProperties of %s is null", (Object)pPath);
        ComponentScopeType scope = ComponentScopeType.valueOf(Util.getLastValue(pProperties, "$scope", ComponentScopeType.GLOBAL.toString()));
        this.logger.debug(() -> "Component[" + pPath + "]:Scope=" + (Object)((Object)scope));
        Map<String, Object> map = mSingletonRepository;
        synchronized (map) {
            if (ComponentScopeType.GLOBAL == scope && mSingletonRepository.containsKey(pPath)) {
                this.logger.debug(() -> "Component[" + pPath + "]:Singleton already initialised");
                result = new Tuple<Boolean, Object>(false, mSingletonRepository.get(pPath));
            } else {
                this.logger.debug(() -> "Component[" + pPath + "]:Creating instance");
                Object instance = null;
                String factoryPath = Util.getLastValue(pProperties, "$instanceFactory");
                if (!Strings.isNullOrEmpty((String)factoryPath)) {
                    this.logger.debug(() -> "Component[" + pPath + "]: Creating instance using factory=" + factoryPath);
                    InstanceFactory factoryInst = (InstanceFactory)Glue.instance().resolve(factoryPath);
                    Optional<Object> inst = factoryInst.createInstance();
                    if (inst.isPresent()) {
                        instance = inst.get();
                    } else {
                        this.logger.debug(() -> "Component[" + pPath + "]: No instance create by factory of " + pPath);
                    }
                } else {
                    String clazz = Util.getLastValue(pProperties, "$class");
                    this.logger.debug(() -> "Component[" + pPath + "]: Creating instance of Class=" + clazz);
                    instance = Util.createInstance(clazz);
                }
                result = new Tuple<Boolean, Object>(true, instance);
                if (ComponentScopeType.GLOBAL == scope) {
                    this.logger.debug(() -> "Component[" + pPath + "]:Adding instance to singleton repository");
                    mSingletonRepository.put(pPath, result.value2);
                }
            }
        }
        return result;
    }

    @Override
    public <T> T resolve(String pPath) {
        return (T)this.resolve(pPath, ComponentRepository.getPropertiesCache().get(pPath));
    }

    public static ComponentRepository instance() {
        return new ComponentRepository();
    }

    public static Map<String, ListMultimap<String, ValueWithModifier>> getPropertiesCache() {
        return mPropertiesRepository.getPropertiesCache();
    }

    static {
        PropertiesRepository.setLayers(Util.getSystemLayers());
        mSingletonRepository = new HashMap<String, Object>();
        mPropertiesRepository = new PropertiesRepository();
        mPropertiesRepository.init();
    }
}

