/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import in.erail.glue.common.FileLoader;
import in.erail.glue.common.JsonLoader;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.component.ServiceArray;
import in.erail.glue.component.ServiceMap;
import in.erail.glue.enumeration.PropertyValueModifier;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValueProxy {
    protected Logger logger = LogManager.getLogger((String)ValueProxy.class.getCanonicalName());
    private static final Pattern DEFERRED_PROPERTY_VALUE_PATTER = Pattern.compile("(?<component>^[^.]+)($|(\\.(?<property>.*)$))");
    private Class targetClass;
    private Collection<ValueWithModifier> propertyValue;
    private String componentPath;
    private Object value;
    private String deferredComponentPath;
    private String deferredComponentProperty;
    private Object deferredComponent;
    private boolean deferredComponentProcessed = false;
    private boolean deferredValue = false;
    private boolean processed = false;

    public ValueProxy() {
    }

    public ValueProxy(Class pTargetClass, Collection<ValueWithModifier> pPropertyValue, String pComponentPath) {
        Matcher m;
        this.targetClass = pTargetClass;
        this.propertyValue = pPropertyValue;
        this.componentPath = pComponentPath;
        ValueWithModifier propValue = this.getLastValueWithModifier();
        if (PropertyValueModifier.FROM.equals((Object)propValue.getPropertyValueModifier())) {
            this.deferredValue = true;
        }
        if (!(this.targetClass.isArray() || String.class.isAssignableFrom(this.targetClass) || List.class.isAssignableFrom(this.targetClass) || Map.class.isAssignableFrom(this.targetClass) || Enum.class.isAssignableFrom(this.targetClass) || Boolean.TYPE.isAssignableFrom(this.targetClass) || Boolean.class.isAssignableFrom(this.targetClass) || JsonObject.class.isAssignableFrom(this.targetClass) || Set.class.isAssignableFrom(this.targetClass) || ServiceMap.class.isAssignableFrom(this.targetClass) || Integer.TYPE.isAssignableFrom(this.targetClass) || Integer.class.isAssignableFrom(this.targetClass) || Long.TYPE.isAssignableFrom(this.targetClass) || Long.class.isAssignableFrom(this.targetClass) || File.class.isAssignableFrom(this.targetClass) || Logger.class.isAssignableFrom(this.targetClass) || ServiceArray.class.isAssignableFrom(this.targetClass) || Pattern.class.isAssignableFrom(this.targetClass) || Meter.class.isAssignableFrom(this.targetClass) || Timer.class.isAssignableFrom(this.targetClass) || Counter.class.isAssignableFrom(this.targetClass) || Histogram.class.isAssignableFrom(this.targetClass) || Strings.isNullOrEmpty((String)propValue.getValue()))) {
            this.deferredValue = true;
        }
        if (this.deferredValue && (m = DEFERRED_PROPERTY_VALUE_PATTER.matcher(propValue.getValue())).find()) {
            this.deferredComponentPath = m.group("component");
            this.deferredComponentProperty = m.group("property");
        }
    }

    public void process() {
        this.setProcessed(true);
        if (this.isDeferredValue()) {
            return;
        }
        if (this.getTargetClass().isArray()) {
            this.setValue(this.getValueAsArray());
        } else if (String.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsString());
        } else if (List.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsList());
        } else if (Map.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsMap());
        } else if (Enum.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsEnum());
        } else if (Boolean.TYPE.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsboolean());
        } else if (Boolean.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsBoolean());
        } else if (JsonObject.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsJson());
        } else if (Set.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsSet());
        } else if (ServiceMap.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(new ServiceMap(this.getValueAsMap()));
        } else if (Integer.TYPE.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsInt());
        } else if (Integer.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsInteger());
        } else if (Long.TYPE.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAslong());
        } else if (Long.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsLong());
        } else if (File.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsFile());
        } else if (Logger.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsLogger());
        } else if (ServiceArray.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(new ServiceArray(this.getValueAsList()));
        } else if (Pattern.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsPattern());
        } else if (Meter.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsMeter());
        } else if (Timer.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsTimer());
        } else if (Counter.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsCounter());
        } else if (Histogram.class.isAssignableFrom(this.getTargetClass())) {
            this.setValue(this.getValueAsHistogram());
        } else if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.setValue(null);
        }
    }

    private Meter getValueAsMeter() {
        return Util.getMetricRegistry().meter(this.getValueAsString());
    }

    private Timer getValueAsTimer() {
        return Util.getMetricRegistry().timer(this.getValueAsString());
    }

    private Counter getValueAsCounter() {
        return Util.getMetricRegistry().counter(this.getValueAsString());
    }

    private Histogram getValueAsHistogram() {
        return Util.getMetricRegistry().histogram(this.getValueAsString());
    }

    private Pattern getValueAsPattern() {
        String v = this.getValueAsString();
        if (Strings.isNullOrEmpty((String)v)) {
            return null;
        }
        return Pattern.compile(v);
    }

    private Logger getValueAsLogger() {
        String loggerName = this.getComponentPath();
        if (loggerName.startsWith("/") && loggerName.length() >= 2) {
            loggerName = loggerName.substring(1);
        }
        return LogManager.getLogger((String)loggerName.replace("/", "."));
    }

    private File getValueAsFile() {
        return FileLoader.load(this.getComponentPath(), this.getValueAsString());
    }

    private int getValueAsInt() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.logger.error(this.componentPath + ":: int value can't be empty. Setting it to 0");
            return 0;
        }
        return Integer.parseInt(this.getValueAsString());
    }

    private Integer getValueAsInteger() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            return null;
        }
        return this.getValueAsInt();
    }

    private long getValueAslong() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.logger.error(this.componentPath + ":: long value can't be empty. Setting it to 0");
            return 0L;
        }
        return Long.parseLong(this.getValueAsString());
    }

    private Long getValueAsLong() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            return null;
        }
        return this.getValueAslong();
    }

    private String[] getValueAsArray() {
        ArrayList result = new ArrayList();
        List v = (List)this.getPropertyValue();
        v.stream().forEach(vwm -> {
            if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                return;
            }
            List<String> l = Arrays.asList(Util.convertCSVIntoArray(vwm.getValue()));
            switch (vwm.getPropertyValueModifier()) {
                case PLUS: {
                    result.addAll(l);
                    break;
                }
                case MINUS: {
                    result.removeAll(l);
                    break;
                }
                default: {
                    result.clear();
                    result.addAll(l);
                }
            }
        });
        return result.toArray(new String[result.size()]);
    }

    private String getValueAsString() {
        String v = this.getLastValueWithModifier().getValue();
        if (Strings.isNullOrEmpty((String)v)) {
            return null;
        }
        return v;
    }

    private Set<String> getValueAsSet() {
        HashSet<String> result = new HashSet<String>();
        List v = (List)this.getPropertyValue();
        v.stream().forEach(vwm -> {
            if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                return;
            }
            List<String> l = Arrays.asList(Util.convertCSVIntoArray(vwm.getValue()));
            switch (vwm.getPropertyValueModifier()) {
                case PLUS: {
                    result.addAll(l);
                    break;
                }
                case MINUS: {
                    result.removeAll(l);
                    break;
                }
                default: {
                    result.clear();
                    result.addAll(l);
                }
            }
        });
        return result;
    }

    private List<String> getValueAsList() {
        ArrayList<String> result = new ArrayList<String>();
        List v = (List)this.getPropertyValue();
        v.stream().forEach(vwm -> {
            if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                return;
            }
            List<String> l = Arrays.asList(Util.convertCSVIntoArray(vwm.getValue()));
            switch (vwm.getPropertyValueModifier()) {
                case PLUS: {
                    result.addAll(l);
                    break;
                }
                case MINUS: {
                    result.removeAll(l);
                    break;
                }
                default: {
                    result.clear();
                    result.addAll(l);
                }
            }
        });
        return result;
    }

    private HashMap<String, String> getValueAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        List v = (List)this.getPropertyValue();
        v.stream().forEach(vwm -> {
            if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                return;
            }
            Map<String, String> m = Util.getMapFromValue(vwm.getValue());
            switch (vwm.getPropertyValueModifier()) {
                case PLUS: {
                    result.putAll(m);
                    break;
                }
                case MINUS: {
                    result.keySet().removeAll(m.keySet());
                    break;
                }
                default: {
                    result.clear();
                    result.putAll(m);
                }
            }
        });
        return result;
    }

    private Enum getValueAsEnum() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.logger.error(this.componentPath + ":: Enum of type:" + this.getTargetClass().getCanonicalName() + " not set");
            return null;
        }
        return Enum.valueOf(this.getTargetClass(), this.getValueAsString());
    }

    private Boolean getValueAsBoolean() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            return null;
        }
        return Boolean.valueOf(this.getValueAsString());
    }

    private boolean getValueAsboolean() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.logger.error(this.componentPath + ":: boolean value can't be empty. Setting it to false");
            return false;
        }
        return Boolean.parseBoolean(this.getValueAsString());
    }

    private JsonObject getValueAsJson() {
        if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            return new JsonObject();
        }
        return JsonLoader.load(this.getComponentPath(), this.getValueAsString());
    }

    private ValueWithModifier getLastValueWithModifier() {
        return Util.getLastValueWithModifier(this.getPropertyValue());
    }

    public Object getValue() {
        if (this.isDeferredValue()) {
            if (this.getDeferredComponentProperty() == null) {
                this.setValue(this.getDeferredComponent());
            } else {
                String getValueMethodName = Util.buildGetPropertyName(this.getDeferredComponentProperty(), Boolean.TYPE.isAssignableFrom(this.getTargetClass()) || Boolean.class.isAssignableFrom(this.getTargetClass()));
                Method getValueMethod = Util.getMethod(this.getDeferredComponent().getClass(), getValueMethodName);
                try {
                    Object getValue = getValueMethod.invoke(this.getDeferredComponent(), new Object[0]);
                    this.setValue(getValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return this.value;
    }

    public void setValue(Object pValue) {
        this.value = pValue;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class pTargetClass) {
        this.targetClass = pTargetClass;
    }

    public String getDeferredComponentPath() {
        return this.deferredComponentPath;
    }

    public Collection<ValueWithModifier> getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(Collection<ValueWithModifier> pPropertyValue) {
        this.propertyValue = pPropertyValue;
    }

    public void setDeferredComponentPath(String pDeferredComponentPath) {
        this.deferredComponentPath = pDeferredComponentPath;
    }

    public String getDeferredComponentProperty() {
        return this.deferredComponentProperty;
    }

    public void setDeferredComponentProperty(String pDeferredComponentProperty) {
        this.deferredComponentProperty = pDeferredComponentProperty;
    }

    public Object getDeferredComponent() {
        return this.deferredComponent;
    }

    public void setDeferredComponent(Object pDeferredComponent) {
        this.deferredComponent = pDeferredComponent;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public void setComponentPath(String pComponentPath) {
        this.componentPath = pComponentPath;
    }

    public boolean isDeferredValue() {
        return this.deferredValue;
    }

    public void setDeferredValue(boolean pDeferredValue) {
        this.deferredValue = pDeferredValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("TargetClass", (Object)this.getTargetClass().getCanonicalName()).add("ComponentPath", (Object)this.getComponentPath()).add("PropertyValue", (Object)Joiner.on((String)",").join(this.getPropertyValue())).toString();
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean pProcessed) {
        this.processed = pProcessed;
    }

    public boolean isDeferredComponentProcessed() {
        return this.deferredComponentProcessed;
    }

    public void setDeferredComponentProcessed(boolean pDeferredComponentProcessed) {
        this.deferredComponentProcessed = pDeferredComponentProcessed;
    }
}

