/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue.factory;

import in.erail.glue.Glue;
import in.erail.glue.InstanceFactory;
import in.erail.glue.ValueProxy;
import in.erail.glue.annotation.StartService;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.PropertyValueModifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Logger;

public class ParameterConstructorInstanceFactory
implements InstanceFactory {
    private String mBaseClass;
    private String[] mConstructorParamValues;
    private String[] mConstructorParamType;
    private Class[] mParamType;
    private Logger mLog;
    private final Map<String, Class> mPrimitiveType = new HashMap<String, Class>();
    private String mComponentPath;
    private boolean mConstructorEnable = true;
    private Constructor mConstructor = null;
    private Object[] mConstructorParam;

    public ParameterConstructorInstanceFactory() {
        this.mPrimitiveType.put("byte.class", Byte.TYPE);
        this.mPrimitiveType.put("short.class", Short.TYPE);
        this.mPrimitiveType.put("int.class", Integer.TYPE);
        this.mPrimitiveType.put("long.class", Long.TYPE);
        this.mPrimitiveType.put("float.class", Float.TYPE);
        this.mPrimitiveType.put("double.class", Double.TYPE);
        this.mPrimitiveType.put("boolean.class", Boolean.TYPE);
        this.mPrimitiveType.put("char.class", Character.TYPE);
    }

    @StartService
    public void start() {
        if (!this.isConstructorEnable()) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.getBaseClass());
            Constructor<?> defaultConstructor = null;
            block2: for (Constructor<?> c : clazz.getConstructors()) {
                if (defaultConstructor == null) {
                    defaultConstructor = c;
                }
                Class<?>[] pType = c.getParameterTypes();
                if (this.getParamType().length != pType.length) continue;
                for (int i = 0; i < pType.length; ++i) {
                    if (!pType[i].equals(this.getParamType()[i])) continue block2;
                }
                this.mConstructor = c;
                break;
            }
            if (this.mConstructor == null) {
                this.mConstructor = defaultConstructor;
            }
            this.mConstructorParam = this.mConstructor == null ? new Object[0] : this.getConstructorMethodParams(this.getConstructorParamValues(), this.mConstructor);
        }
        catch (ClassNotFoundException | SecurityException ex) {
            this.getLog().error((Object)ex);
        }
    }

    @Override
    public Optional<Object> createInstance() {
        if (!this.isConstructorEnable() || this.mConstructor == null) {
            return Optional.empty();
        }
        Object instance = null;
        try {
            instance = this.mConstructor.newInstance(this.mConstructorParam);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            this.getLog().error((Object)ex);
        }
        return Optional.ofNullable(instance);
    }

    protected Object[] getConstructorMethodParams(String[] pParams, Constructor pConstructor) {
        Class<?>[] paramsType = pConstructor.getParameterTypes();
        Object[] params = new Object[paramsType.length];
        for (int i = 0; i < paramsType.length; ++i) {
            ValueWithModifier vm = new ValueWithModifier(pParams[i], PropertyValueModifier.NONE);
            ArrayList<ValueWithModifier> vmc = new ArrayList<ValueWithModifier>(1);
            vmc.add(vm);
            ValueProxy vp = new ValueProxy(paramsType[i], vmc, this.getComponentPath());
            vp.process();
            params[i] = vp.isDeferredValue() ? Glue.instance().resolve(vp.getDeferredComponentPath()) : vp.getValue();
        }
        return params;
    }

    protected Class[] getConstructorParamType(String[] pParamsType) {
        Class[] result;
        if (pParamsType != null) {
            try {
                result = new Class[pParamsType.length];
                for (int i = 0; i < pParamsType.length; ++i) {
                    String clazz = pParamsType[i];
                    result[i] = this.mPrimitiveType.containsKey(clazz) ? this.mPrimitiveType.get(clazz) : Class.forName(clazz);
                }
            }
            catch (ClassNotFoundException ex) {
                result = new Class[]{};
                this.getLog().error((Object)ex);
            }
        } else {
            result = new Class[]{};
        }
        return result;
    }

    public String getBaseClass() {
        return this.mBaseClass;
    }

    public void setBaseClass(String pBaseClass) {
        this.mBaseClass = pBaseClass;
    }

    public String[] getConstructorParamValues() {
        return this.mConstructorParamValues;
    }

    public void setConstructorParamValues(String[] pConstructorParamValues) {
        this.mConstructorParamValues = pConstructorParamValues;
    }

    public String[] getConstructorParamType() {
        return this.mConstructorParamType;
    }

    public void setConstructorParamType(String[] pConstructorParamType) {
        this.mConstructorParamType = pConstructorParamType;
        this.mParamType = this.getConstructorParamType(pConstructorParamType);
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Class[] getParamType() {
        if (this.mParamType == null) {
            this.mParamType = new Class[0];
        }
        return this.mParamType;
    }

    public void setParamType(Class[] pParamType) {
        this.mParamType = pParamType;
    }

    public String getComponentPath() {
        return this.mComponentPath;
    }

    public void setComponentPath(String pComponentPath) {
        this.mComponentPath = pComponentPath;
    }

    public boolean isConstructorEnable() {
        return this.mConstructorEnable;
    }

    public void setConstructorEnable(boolean pConstructorEnable) {
        this.mConstructorEnable = pConstructorEnable;
    }
}

