/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.google.common.base.Strings;
import in.erail.glue.DefaultValueProxy;
import in.erail.glue.ValueProxy;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import java.util.Collection;

public class ValueProxyBuilder {
    private static Class valueProxyClass;
    private Class mTargetClass;
    private Collection<ValueWithModifier> mPropertyValue;
    private String mComponentPath;

    public Class getTargetClass() {
        return this.mTargetClass;
    }

    public ValueProxyBuilder setTargetClass(Class pTargetClass) {
        this.mTargetClass = pTargetClass;
        return this;
    }

    public Collection<ValueWithModifier> getPropertyValue() {
        return this.mPropertyValue;
    }

    public ValueProxyBuilder setPropertyValue(Collection<ValueWithModifier> pPropertyValue) {
        this.mPropertyValue = pPropertyValue;
        return this;
    }

    public String getComponentPath() {
        return this.mComponentPath;
    }

    public ValueProxyBuilder setComponentPath(String pComponentPath) {
        this.mComponentPath = pComponentPath;
        return this;
    }

    public static ValueProxyBuilder newBuilder() {
        return new ValueProxyBuilder();
    }

    public ValueProxy build() {
        try {
            ValueProxy vp = (ValueProxy)valueProxyClass.newInstance();
            vp.setTargetClass(this.getTargetClass());
            vp.setPropertyValue(this.getPropertyValue());
            vp.setComponentPath(this.getComponentPath());
            vp.init();
            return vp;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        String envValueProxyClassName = Util.getEnvironmentValue("glue.value.proxy.class");
        if (Strings.isNullOrEmpty((String)envValueProxyClassName)) {
            valueProxyClass = DefaultValueProxy.class;
        } else {
            try {
                valueProxyClass = Class.forName(envValueProxyClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

