/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue.factory;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import in.erail.glue.Glue;
import in.erail.glue.InstanceFactory;
import in.erail.glue.ValueProxy;
import in.erail.glue.ValueProxyBuilder;
import in.erail.glue.annotation.StartService;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.PropertyValueModifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.Logger;

public class MethodInstanceFactory
implements InstanceFactory {
    private String mFactoryClass;
    private String mFactoryInstance;
    private String mFactoryMethodName;
    private String[] mFactoryParamValues;
    private String[] mFactoryParamType;
    private Logger mLog;
    private Class[] mParamType;
    private String mComponentPath;
    private boolean mFactoryEnable = true;
    private Method mMethod;
    private Object[] mMethodParam;
    private Class mMethodClass;
    private Object mMethodClassInstance;
    private final Map<String, Class> mPrimitiveType = new HashMap<String, Class>();

    public MethodInstanceFactory() {
        this.mPrimitiveType.put("byte.class", Byte.TYPE);
        this.mPrimitiveType.put("short.class", Short.TYPE);
        this.mPrimitiveType.put("int.class", Integer.TYPE);
        this.mPrimitiveType.put("long.class", Long.TYPE);
        this.mPrimitiveType.put("float.class", Float.TYPE);
        this.mPrimitiveType.put("double.class", Double.TYPE);
        this.mPrimitiveType.put("boolean.class", Boolean.TYPE);
        this.mPrimitiveType.put("char.class", Character.TYPE);
    }

    @StartService
    public void start() {
        if (!this.isFactoryEnable()) {
            return;
        }
        this.getLog().debug(() -> this);
        try {
            if (!Strings.isNullOrEmpty((String)this.getFactoryClass())) {
                this.mMethodClass = Class.forName(this.getFactoryClass());
            } else if (!Strings.isNullOrEmpty((String)this.getFactoryInstance())) {
                this.mMethodClassInstance = Glue.instance().resolve(this.getFactoryInstance());
                this.mMethodClass = this.mMethodClassInstance.getClass();
            } else {
                this.getLog().error("Not able to create instance" + this);
                return;
            }
            Method defaultMethod = null;
            block2: for (Method m : this.mMethodClass.getMethods()) {
                if (!m.getName().equals(this.getFactoryMethodName())) continue;
                if (defaultMethod == null) {
                    defaultMethod = m;
                }
                Class<?>[] pType = m.getParameterTypes();
                if (this.getParamType().length != pType.length) continue;
                for (int i = 0; i < pType.length; ++i) {
                    if (!pType[i].equals(this.getParamType()[i])) continue block2;
                }
                this.mMethod = m;
                break;
            }
            if (this.mMethod == null) {
                this.mMethod = defaultMethod;
            }
            if (this.mMethodClassInstance == null && this.mMethod != null && !Modifier.isStatic(this.mMethod.getModifiers())) {
                this.mMethodClassInstance = this.mMethodClass.newInstance();
            }
            this.mMethodParam = this.mMethod == null ? new Object[0] : this.getFactoryMethodParams(this.getFactoryParamValues(), this.mMethod);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Optional createInstance() {
        if (!this.isFactoryEnable() || this.mMethod == null) {
            return Optional.empty();
        }
        Object instance = null;
        try {
            instance = this.mMethod.invoke(this.mMethodClassInstance, this.mMethodParam);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return Optional.ofNullable(instance);
    }

    protected Optional<Method> findFactoryMethod(Class pClazz, String pMethodName, Class[] pParamsType) {
        Method method = null;
        if (pParamsType.length == 0) {
            for (Method m : pClazz.getMethods()) {
                if (!m.getName().equals(pMethodName)) continue;
                method = m;
                break;
            }
        } else {
            try {
                method = pClazz.getMethod(this.getFactoryMethodName(), pParamsType);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                this.getLog().error((Object)ex);
            }
        }
        return Optional.ofNullable(method);
    }

    protected Class[] getFactoryParamType(String[] pParamsType) {
        Class[] result;
        if (pParamsType != null) {
            try {
                result = new Class[pParamsType.length];
                for (int i = 0; i < pParamsType.length; ++i) {
                    String clazz = pParamsType[i];
                    result[i] = this.mPrimitiveType.containsKey(clazz) ? this.mPrimitiveType.get(clazz) : Class.forName(clazz);
                }
            }
            catch (ClassNotFoundException ex) {
                result = new Class[]{};
                this.getLog().error((Object)ex);
            }
        } else {
            result = new Class[]{};
        }
        return result;
    }

    protected Object[] getFactoryMethodParams(String[] pParams, Method pMethod) {
        Class<?>[] paramsType = pMethod.getParameterTypes();
        Object[] params = new Object[paramsType.length];
        for (int i = 0; i < paramsType.length; ++i) {
            ValueWithModifier vm = new ValueWithModifier(pParams[i], PropertyValueModifier.NONE);
            ArrayList<ValueWithModifier> vmc = new ArrayList<ValueWithModifier>(1);
            vmc.add(vm);
            ValueProxy vp = ValueProxyBuilder.newBuilder().setTargetClass(paramsType[i]).setPropertyValue(vmc).setComponentPath(this.getComponentPath()).build();
            vp.process();
            params[i] = vp.isDeferredValue() ? Glue.instance().resolve(vp.getDeferredComponentPath()) : vp.getValue();
        }
        return params;
    }

    public String getFactoryClass() {
        return this.mFactoryClass;
    }

    public void setFactoryClass(String pFactoryClass) {
        this.mFactoryClass = pFactoryClass;
    }

    public String getFactoryInstance() {
        return this.mFactoryInstance;
    }

    public void setFactoryInstance(String pFactoryInstance) {
        this.mFactoryInstance = pFactoryInstance;
    }

    public String getFactoryMethodName() {
        return this.mFactoryMethodName;
    }

    public void setFactoryMethodName(String pFactoryMethodName) {
        this.mFactoryMethodName = pFactoryMethodName;
    }

    public String[] getFactoryParamValues() {
        return this.mFactoryParamValues;
    }

    public void setFactoryParamValues(String[] pFactoryParamValues) {
        this.mFactoryParamValues = pFactoryParamValues;
    }

    public String[] getFactoryParamType() {
        return this.mFactoryParamType;
    }

    public void setFactoryParamType(String[] pFactoryParamType) {
        this.mFactoryParamType = pFactoryParamType;
        this.mParamType = this.getFactoryParamType(pFactoryParamType);
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Class[] getParamType() {
        if (this.mParamType == null) {
            this.mParamType = new Class[0];
        }
        return this.mParamType;
    }

    public String getComponentPath() {
        return this.mComponentPath;
    }

    public void setComponentPath(String pComponentPath) {
        this.mComponentPath = pComponentPath;
    }

    public boolean isFactoryEnable() {
        return this.mFactoryEnable;
    }

    public void setFactoryEnable(boolean pFactoryEnable) {
        this.mFactoryEnable = pFactoryEnable;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mFactoryClass", (Object)this.mFactoryClass).add("mFactoryInstance", (Object)this.mFactoryInstance).add("mFactoryMethodName", (Object)this.mFactoryMethodName).add("mFactoryParamValues", this.mFactoryParamValues != null ? Joiner.on((String)",").join((Object[])this.mFactoryParamValues) : null).add("mFactoryParamType", this.mFactoryParamType != null ? Joiner.on((String)",").join((Object[])this.mFactoryParamType) : null).add("mParamType", this.mParamType != null ? Joiner.on((String)",").join((Object[])this.mParamType) : null).add("mComponentPath", (Object)this.mComponentPath).add("mFactoryEnable", this.mFactoryEnable).add("mMethod", this.mMethod != null ? this.mMethod.getName() : null).add("mMethodParam", this.mMethodParam != null ? Joiner.on((String)",").join(this.mMethodParam) : null).add("mMethodClass", this.mMethodClass != null ? this.mMethodClass.getCanonicalName() : null).add("mMethodClassInstance", this.mMethodClassInstance != null ? this.mMethodClassInstance.getClass().toGenericString() : null).toString();
    }
}

