/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import in.erail.glue.ProxyValueResolverRegistry;
import in.erail.glue.ValueProxy;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.PropertyValueModifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultValueProxy
implements ValueProxy {
    protected Logger logger = LogManager.getLogger((String)DefaultValueProxy.class.getCanonicalName());
    private static final Pattern DEFERRED_PROPERTY_VALUE_PATTER = Pattern.compile("(?<component>^[^.]+)($|(\\.(?<property>.*)$))");
    private Class targetClass;
    private Collection<ValueWithModifier> propertyValue;
    private String componentPath;
    private Object value;
    private String deferredComponentPath;
    private String deferredComponentProperty;
    private Object deferredComponent;
    private boolean deferredComponentProcessed = false;
    private boolean deferredValue = false;
    private boolean processed = false;

    @Override
    public void init() {
        Matcher m;
        ValueWithModifier propValue = this.getLastValueWithModifier();
        if (PropertyValueModifier.FROM.equals((Object)propValue.getPropertyValueModifier())) {
            this.deferredValue = true;
        }
        if (!(this.targetClass.isArray() || this.targetClass.isEnum() || ProxyValueResolverRegistry.getClassToValue().containsKey(this.targetClass) || Strings.isNullOrEmpty((String)propValue.getValue()))) {
            this.deferredValue = true;
        }
        if (this.deferredValue && (m = DEFERRED_PROPERTY_VALUE_PATTER.matcher(propValue.getValue())).find()) {
            this.deferredComponentPath = m.group("component");
            this.deferredComponentProperty = m.group("property");
        }
    }

    @Override
    public void process() {
        this.setProcessed(true);
        if (this.isDeferredValue()) {
            return;
        }
        if (this.getTargetClass().isArray()) {
            this.setValue(ProxyValueResolverRegistry.createArray(this.targetClass).apply(this.getPropertyValue(), this));
        } else if (this.getTargetClass().isEnum()) {
            this.setValue(ProxyValueResolverRegistry.getClassToValue().get(Enum.class).apply(this.getPropertyValue(), this));
        } else if (ProxyValueResolverRegistry.getClassToValue().containsKey(this.targetClass)) {
            this.setValue(ProxyValueResolverRegistry.getClassToValue().get(this.targetClass).apply(this.getPropertyValue(), this));
        } else if (Strings.isNullOrEmpty((String)this.getValueAsString())) {
            this.setValue(null);
        }
    }

    protected String getValueAsString() {
        String v = this.getLastValueWithModifier().getValue();
        if (Strings.isNullOrEmpty((String)v)) {
            return null;
        }
        return v;
    }

    protected ValueWithModifier getLastValueWithModifier() {
        return Util.getLastValueWithModifier(this.getPropertyValue());
    }

    @Override
    public Object getValue() {
        if (this.isDeferredValue()) {
            if (this.getDeferredComponentProperty() == null) {
                this.setValue(this.getDeferredComponent());
            } else {
                String getValueMethodName = Util.buildGetPropertyName(this.getDeferredComponentProperty(), Boolean.TYPE.isAssignableFrom(this.getTargetClass()) || Boolean.class.isAssignableFrom(this.getTargetClass()));
                Method getValueMethod = Util.getMethod(this.getDeferredComponent().getClass(), getValueMethodName);
                try {
                    Object getValue = getValueMethod.invoke(this.getDeferredComponent(), new Object[0]);
                    this.setValue(getValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return this.value;
    }

    protected void setValue(Object pValue) {
        this.value = pValue;
    }

    @Override
    public Class getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(Class pTargetClass) {
        this.targetClass = pTargetClass;
    }

    @Override
    public String getDeferredComponentPath() {
        return this.deferredComponentPath;
    }

    protected Collection<ValueWithModifier> getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public void setPropertyValue(Collection<ValueWithModifier> pPropertyValue) {
        this.propertyValue = pPropertyValue;
    }

    protected void setDeferredComponentPath(String pDeferredComponentPath) {
        this.deferredComponentPath = pDeferredComponentPath;
    }

    protected String getDeferredComponentProperty() {
        return this.deferredComponentProperty;
    }

    protected void setDeferredComponentProperty(String pDeferredComponentProperty) {
        this.deferredComponentProperty = pDeferredComponentProperty;
    }

    protected Object getDeferredComponent() {
        return this.deferredComponent;
    }

    @Override
    public void setDeferredComponent(Object pDeferredComponent) {
        this.deferredComponent = pDeferredComponent;
    }

    protected String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setComponentPath(String pComponentPath) {
        this.componentPath = pComponentPath;
    }

    @Override
    public boolean isDeferredValue() {
        return this.deferredValue;
    }

    protected void setDeferredValue(boolean pDeferredValue) {
        this.deferredValue = pDeferredValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("TargetClass", (Object)this.getTargetClass().getCanonicalName()).add("ComponentPath", (Object)this.getComponentPath()).add("PropertyValue", (Object)Joiner.on((String)",").join(this.getPropertyValue())).toString();
    }

    protected boolean isProcessed() {
        return this.processed;
    }

    protected void setProcessed(boolean pProcessed) {
        this.processed = pProcessed;
    }

    @Override
    public boolean isDeferredComponentProcessed() {
        return this.deferredComponentProcessed;
    }

    @Override
    public void setDeferredComponentProcessed(boolean pDeferredComponentProcessed) {
        this.deferredComponentProcessed = pDeferredComponentProcessed;
    }
}

