/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import in.erail.glue.DefaultValueProxy;
import in.erail.glue.Glue;
import in.erail.glue.common.FileLoader;
import in.erail.glue.common.JsonLoader;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.component.ServiceMap;
import in.erail.glue.enumeration.PropertyValueModifier;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;

public class ProxyValueResolverRegistry {
    private static final Map<Class, BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object>> classToValue = new HashMap<Class, BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object>>();

    public static Map<Class, BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object>> getClassToValue() {
        return classToValue;
    }

    public static BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> createList(Class pClazz) {
        if (classToValue.containsKey(pClazz)) {
            return classToValue.get(pClazz);
        }
        BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> fnNew = (t, u) -> {
            try {
                List result = (List)pClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List v = (List)t;
                v.stream().forEach(vwm -> {
                    if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                        return;
                    }
                    List<String> l = Arrays.asList(Util.convertCSVIntoArray(vwm.getValue()));
                    switch (vwm.getPropertyValueModifier()) {
                        case PLUS: {
                            result.addAll(l);
                            break;
                        }
                        case MINUS: {
                            result.removeAll(l);
                            break;
                        }
                        default: {
                            result.clear();
                            result.addAll(l);
                        }
                    }
                });
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ProxyValueResolverRegistry.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        };
        BiFunction<Collection, DefaultValueProxy, Object> fnOld = classToValue.putIfAbsent(pClazz, fnNew);
        return fnOld == null ? fnNew : fnOld;
    }

    public static BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> createMap(Class pClazz) {
        if (classToValue.containsKey(pClazz)) {
            return classToValue.get(pClazz);
        }
        BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> fnNew = (t, u) -> {
            try {
                Map result = (Map)pClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List v = (List)t;
                v.stream().forEach(vwm -> {
                    if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                        return;
                    }
                    Map<String, String> m = Util.getMapFromValue(vwm.getValue());
                    switch (vwm.getPropertyValueModifier()) {
                        case PLUS: {
                            result.putAll(m);
                            break;
                        }
                        case MINUS: {
                            result.keySet().removeAll(m.keySet());
                            break;
                        }
                        default: {
                            result.clear();
                            result.putAll(m);
                        }
                    }
                });
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ProxyValueResolverRegistry.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        };
        BiFunction<Collection, DefaultValueProxy, Object> fnOld = classToValue.putIfAbsent(pClazz, fnNew);
        return fnOld == null ? fnNew : fnOld;
    }

    public static BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> createSet(Class pClazz) {
        if (classToValue.containsKey(pClazz)) {
            return classToValue.get(pClazz);
        }
        BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> fnNew = (t, u) -> {
            try {
                Set result = (Set)pClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                List v = (List)t;
                v.stream().forEach(vwm -> {
                    if (Strings.isNullOrEmpty((String)vwm.getValue())) {
                        return;
                    }
                    List<String> l = Arrays.asList(Util.convertCSVIntoArray(vwm.getValue()));
                    switch (vwm.getPropertyValueModifier()) {
                        case PLUS: {
                            result.addAll(l);
                            break;
                        }
                        case MINUS: {
                            result.removeAll(l);
                            break;
                        }
                        default: {
                            result.clear();
                            result.addAll(l);
                        }
                    }
                });
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                Logger.getLogger(ProxyValueResolverRegistry.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        };
        BiFunction<Collection, DefaultValueProxy, Object> fnOld = classToValue.putIfAbsent(pClazz, fnNew);
        return fnOld == null ? fnNew : fnOld;
    }

    public static BiFunction<Collection<ValueWithModifier>, DefaultValueProxy, Object> createArray(Class pClazz) {
        if (classToValue.containsKey(pClazz)) {
            return classToValue.get(pClazz);
        }
        if (classToValue.containsKey(pClazz.getComponentType())) {
            classToValue.putIfAbsent(pClazz, (t, u) -> {
                List items = (List)classToValue.get(List.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
                Object result = Array.newInstance(pClazz.getComponentType(), items.size());
                for (int i = 0; i < items.size(); ++i) {
                    String item = (String)items.get(i);
                    ArrayList<ValueWithModifier> v = new ArrayList<ValueWithModifier>(1);
                    ValueWithModifier vwm = new ValueWithModifier(item, PropertyValueModifier.NONE);
                    v.add(vwm);
                    Array.set(result, i, classToValue.get(pClazz.getComponentType()).apply((Collection<ValueWithModifier>)v, (DefaultValueProxy)u));
                }
                return result;
            });
        } else {
            classToValue.putIfAbsent(pClazz, (t, u) -> {
                List result = (List)classToValue.get(List.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
                return result.stream().map(c -> Glue.instance().resolve((String)c)).collect(Collectors.toList()).toArray();
            });
        }
        return classToValue.get(pClazz);
    }

    static {
        classToValue.put(String.class, (t, u) -> {
            String v = Util.getLastValueWithModifier(t).getValue();
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return v;
        });
        classToValue.put(JsonObject.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return new JsonObject();
            }
            return JsonLoader.load(u.getComponentPath(), v);
        });
        classToValue.put(ServiceMap.class, (t, u) -> new ServiceMap((Map)classToValue.get(Map.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(Enum.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return Enum.valueOf(u.getTargetClass(), v);
        });
        classToValue.put(Boolean.TYPE, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return false;
            }
            return Boolean.parseBoolean(v);
        });
        classToValue.put(Boolean.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return Boolean.valueOf(v);
        });
        classToValue.put(Integer.TYPE, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return 0;
            }
            return Integer.parseInt(v);
        });
        classToValue.put(Integer.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return (Integer)classToValue.get(Integer.TYPE).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
        });
        classToValue.put(Long.TYPE, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return 0L;
            }
            return Long.parseLong(v);
        });
        classToValue.put(Long.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return (Long)classToValue.get(Long.TYPE).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
        });
        classToValue.put(File.class, (t, u) -> FileLoader.load(u.getComponentPath(), (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(org.apache.logging.log4j.Logger.class, (t, u) -> {
            String loggerName = u.getComponentPath();
            if (loggerName.startsWith("/") && loggerName.length() >= 2) {
                loggerName = loggerName.substring(1);
            }
            return LogManager.getLogger((String)loggerName.replace("/", "."));
        });
        classToValue.put(Pattern.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            return Pattern.compile(v);
        });
        classToValue.put(Meter.class, (t, u) -> Util.getMetricRegistry().meter((String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(Timer.class, (t, u) -> Util.getMetricRegistry().timer((String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(Counter.class, (t, u) -> Util.getMetricRegistry().counter((String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(Histogram.class, (t, u) -> Util.getMetricRegistry().histogram((String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u)));
        classToValue.put(Class.class, (t, u) -> {
            String v = (String)classToValue.get(String.class).apply((Collection<ValueWithModifier>)t, (DefaultValueProxy)u);
            if (Strings.isNullOrEmpty((String)v)) {
                return null;
            }
            try {
                return Class.forName(v);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(ProxyValueResolverRegistry.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        });
        ProxyValueResolverRegistry.createList(ArrayList.class);
        classToValue.put(List.class, ProxyValueResolverRegistry.createList(ArrayList.class));
        classToValue.put(Collection.class, ProxyValueResolverRegistry.createList(ArrayList.class));
        ProxyValueResolverRegistry.createMap(HashMap.class);
        classToValue.put(Map.class, ProxyValueResolverRegistry.createMap(HashMap.class));
        ProxyValueResolverRegistry.createSet(HashSet.class);
        classToValue.put(Set.class, ProxyValueResolverRegistry.createSet(HashSet.class));
    }
}

