/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue.common;

import in.erail.glue.PropertiesRepository;
import in.erail.glue.common.Util;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileLoader {
    public static List<String> layers;
    private static final Pattern COMPONENT_FOLDER_REGEX;

    public static File load(String pComponentPath, String pFile) {
        Matcher m = COMPONENT_FOLDER_REGEX.matcher(pComponentPath);
        String componentFolder = "/";
        if (m.find()) {
            componentFolder = m.group("folder") + "/";
        }
        if (Util.isOSWindows()) {
            componentFolder = componentFolder.replace("/", "\\");
        }
        String cf = componentFolder;
        List filePaths = layers.stream().map(p -> p + cf + pFile).map(p -> Paths.get(p, new String[0])).filter(p -> Files.exists(p, new LinkOption[0])).collect(Collectors.toList());
        if (filePaths.size() > 0) {
            return ((Path)filePaths.get(filePaths.size() - 1)).toFile();
        }
        return null;
    }

    static {
        COMPONENT_FOLDER_REGEX = Pattern.compile("^(?<folder>.*)/.*$");
        if (PropertiesRepository.layers == null) {
            PropertiesRepository.setLayers(Util.getSystemLayers());
        }
        layers = PropertiesRepository.layers;
    }
}

