/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import in.erail.glue.ConfigSerializationFactory;
import in.erail.glue.common.Tuple;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.PropertyValueModifier;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.subjects.UnicastSubject;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertiesRepository {
    protected Logger logger = LogManager.getLogger((String)PropertiesRepository.class.getCanonicalName());
    public static List<String> layers;
    private static final Pattern COMPONENT_PATH_REGEX;
    private static final String PROPERTY_EXTENSION = ".properties";
    private Map<String, ListMultimap<String, ValueWithModifier>> mPropertiesRepository;
    private final AtomicLong mInstanceFactoryCounter = new AtomicLong();
    private boolean mInitialized = false;

    public PropertiesRepository() {
        this.mPropertiesRepository = Collections.emptyMap();
    }

    public void init() {
        ConfigSerializationFactory factory = Util.getConfigSerializationFactory();
        this.mPropertiesRepository = (Map)factory.load().switchIfEmpty(this.loadConfig()).flatMap(t -> {
            this.setInitialized(true);
            return factory.save((Map<String, ListMultimap<String, ValueWithModifier>>)t).andThen((SingleSource)Single.just((Object)t));
        }).blockingGet();
    }

    private Single<Map<String, ListMultimap<String, ValueWithModifier>>> loadConfig() {
        HashMap<String, ListMultimap<String, ValueWithModifier>> propertiesRepository = new HashMap<String, ListMultimap<String, ValueWithModifier>>();
        UnicastSubject instanceOfFactoryProperties = UnicastSubject.create();
        Observable paths = Observable.fromIterable(PropertiesRepository.getLayers()).map(path -> Paths.get(path, new String[0])).flatMap(this::findAllPropertiesFile);
        Observable<ListMultimap<String, ValueWithModifier>> cachedProperties = this.loadCachedProperties((Observable<Tuple<Path, Path>>)paths, propertiesRepository);
        Observable<Properties> newProperties = this.loadUncachedProperties((Observable<Tuple<Path, Path>>)paths);
        return cachedProperties.zipWith(newProperties, this::mergeUncachedIntoCachedProperties).flatMapCompletable(t -> t).andThen((ObservableSource)Observable.fromIterable(propertiesRepository.entrySet())).doOnNext(t -> this.updateBasedOnProperties((String)t.getKey(), (ListMultimap<String, ValueWithModifier>)((ListMultimap)t.getValue()), propertiesRepository)).doOnNext(t -> {
            String factoryPath = Util.getLastValue((ListMultimap<String, ValueWithModifier>)((ListMultimap)t.getValue()), "$instanceFactory");
            if (Strings.isNullOrEmpty((String)factoryPath)) {
                return;
            }
            Map.Entry<String, ListMultimap<String, ValueWithModifier>> newFactoryProperties = this.createInstanceFactoryProperties(factoryPath, (String)t.getKey(), this.mInstanceFactoryCounter);
            instanceOfFactoryProperties.onNext(newFactoryProperties);
            ((ListMultimap)t.getValue()).put((Object)"$instanceFactory", (Object)new ValueWithModifier(newFactoryProperties.getKey(), PropertyValueModifier.NONE));
        }).doOnComplete(() -> instanceOfFactoryProperties.onComplete()).concatWith((ObservableSource)instanceOfFactoryProperties.doOnNext(p -> {
            ListMultimap cfr_ignored_0 = (ListMultimap)propertiesRepository.put((String)p.getKey(), (ListMultimap<String, ValueWithModifier>)p.getValue());
        })).doOnNext(t -> this.updateBasedOnProperties((String)t.getKey(), (ListMultimap<String, ValueWithModifier>)((ListMultimap)t.getValue()), propertiesRepository)).doOnNext(t -> this.updateBasedOnSpecialProperties((String)t.getKey(), (ListMultimap<String, ValueWithModifier>)((ListMultimap)t.getValue()), propertiesRepository)).ignoreElements().toSingleDefault(propertiesRepository);
    }

    private Map.Entry<String, ListMultimap<String, ValueWithModifier>> createInstanceFactoryProperties(String pInstFactoryComponentPath, String pSourceComponentPath, AtomicLong pCounter) {
        String componentPath = pInstFactoryComponentPath + ":" + pCounter.incrementAndGet();
        ArrayListMultimap properties = ArrayListMultimap.create();
        ValueWithModifier basedOn = new ValueWithModifier(pInstFactoryComponentPath, PropertyValueModifier.NONE);
        ValueWithModifier basedOnSpecialProperties = new ValueWithModifier(pSourceComponentPath, PropertyValueModifier.NONE);
        properties.put((Object)"$basedOn", (Object)basedOn);
        properties.put((Object)"$_basedOn", (Object)basedOnSpecialProperties);
        return new AbstractMap.SimpleEntry<String, ArrayListMultimap>(componentPath, properties);
    }

    private void updateBasedOnSpecialProperties(String pComponentPath, ListMultimap<String, ValueWithModifier> pProperties, Map<String, ListMultimap<String, ValueWithModifier>> pPropertiesRepository) {
        String baseOnSpecialComponentPath = Util.getLastValue(pProperties, "$_basedOn");
        if (Strings.isNullOrEmpty((String)baseOnSpecialComponentPath)) {
            return;
        }
        ListMultimap<String, ValueWithModifier> baseOnSpecialProperties = pPropertiesRepository.get(baseOnSpecialComponentPath);
        ArrayListMultimap newProperties = ArrayListMultimap.create();
        baseOnSpecialProperties.entries().stream().filter(t -> ((String)t.getKey()).startsWith("$")).filter(t -> !"$basedOn".equals(t.getKey())).filter(t -> !"$scope".equals(t.getKey())).filter(t -> !"$instanceFactory".equals(t.getKey())).filter(t -> !"$_basedOn".equals(t.getKey())).forEachOrdered(arg_0 -> PropertiesRepository.lambda$updateBasedOnSpecialProperties$14((ListMultimap)newProperties, arg_0));
        pProperties.entries().stream().filter(p -> !"$_basedOn".equals(p.getKey())).forEachOrdered(arg_0 -> PropertiesRepository.lambda$updateBasedOnSpecialProperties$16((ListMultimap)newProperties, arg_0));
        pProperties.clear();
        pProperties.putAll((Multimap)newProperties);
    }

    private void updateBasedOnProperties(String pComponentPath, ListMultimap<String, ValueWithModifier> pProperties, Map<String, ListMultimap<String, ValueWithModifier>> pPropertiesRepository) {
        String baseOnComponentPath = Util.getLastValue(pProperties, "$basedOn");
        if (Strings.isNullOrEmpty((String)baseOnComponentPath)) {
            return;
        }
        ListMultimap<String, ValueWithModifier> baseOnProperties = pPropertiesRepository.get(baseOnComponentPath);
        if (Util.getLastValue(baseOnProperties, "$basedOn") != null) {
            this.updateBasedOnProperties(baseOnComponentPath, baseOnProperties, pPropertiesRepository);
        }
        ArrayListMultimap newProperties = ArrayListMultimap.create();
        baseOnProperties.entries().stream().forEachOrdered(arg_0 -> PropertiesRepository.lambda$updateBasedOnProperties$17((ListMultimap)newProperties, arg_0));
        pProperties.entries().stream().filter(p -> !"$basedOn".equals(p.getKey())).forEachOrdered(arg_0 -> PropertiesRepository.lambda$updateBasedOnProperties$19((ListMultimap)newProperties, arg_0));
        pProperties.clear();
        pProperties.putAll((Multimap)newProperties);
    }

    private Completable mergeUncachedIntoCachedProperties(ListMultimap<String, ValueWithModifier> pCached, Properties pUncached) {
        Observable property = Observable.fromIterable(pUncached.entrySet()).map(e -> new AbstractMap.SimpleEntry<String, String>(e.getKey().toString(), e.getValue().toString()));
        Observable key = property.map(e -> (String)e.getKey()).map(this::extractKey);
        Observable modifier = property.map(e -> (String)e.getKey()).map(this::extractPropertyValueModifier);
        Observable value = property.map(e -> (String)e.getValue()).zipWith((ObservableSource)modifier, (v, m) -> new ValueWithModifier((String)v, (PropertyValueModifier)((Object)m)));
        return key.zipWith((ObservableSource)value, (k, v) -> pCached.put(k, v)).ignoreElements();
    }

    private String extractKey(String pEntry) {
        String modifier;
        switch (modifier = pEntry.substring(pEntry.length() - 1)) {
            case "+": 
            case "-": 
            case "^": {
                return pEntry.substring(0, pEntry.length() - 1);
            }
        }
        return pEntry;
    }

    private PropertyValueModifier extractPropertyValueModifier(String pEntry) {
        String modifier;
        switch (modifier = pEntry.substring(pEntry.length() - 1)) {
            case "+": {
                return PropertyValueModifier.PLUS;
            }
            case "-": {
                return PropertyValueModifier.MINUS;
            }
            case "^": {
                return PropertyValueModifier.FROM;
            }
        }
        return PropertyValueModifier.NONE;
    }

    private Observable<Properties> loadUncachedProperties(Observable<Tuple<Path, Path>> pPath) {
        return pPath.map(p -> {
            Properties item = new Properties();
            this.logger.debug(() -> "Loading Property File:" + p.value2);
            try {
                item.load(Files.newBufferedReader((Path)p.value2));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return item;
        });
    }

    private Observable<ListMultimap<String, ValueWithModifier>> loadCachedProperties(Observable<Tuple<Path, Path>> pPath, Map<String, ListMultimap<String, ValueWithModifier>> pPropertiesRepository) {
        return pPath.map(path -> {
            String rootDirPath = ((Path)path.value1).toString();
            String absPropertyPath = ((Path)path.value2).toString();
            String propertyPath = absPropertyPath.substring(rootDirPath.length());
            Matcher m = COMPONENT_PATH_REGEX.matcher(propertyPath);
            if (m.find()) {
                String componentPath = m.group("path");
                String key = Util.isOSWindows() ? componentPath.replace("\\", "/") : componentPath;
                if (pPropertiesRepository.containsKey(key)) {
                    return (ListMultimap)pPropertiesRepository.get(key);
                }
                ArrayListMultimap properties = ArrayListMultimap.create();
                properties.put((Object)"$componentPath", (Object)new ValueWithModifier(key, PropertyValueModifier.NONE));
                properties.put((Object)"glueMountPath", (Object)new ValueWithModifier(key, PropertyValueModifier.NONE));
                pPropertiesRepository.put(key, (ListMultimap<String, ValueWithModifier>)properties);
                return properties;
            }
            throw new RuntimeException("Component path empty: " + path.toString());
        });
    }

    private Observable<Tuple<Path, Path>> findAllPropertiesFile(Path pPath) {
        return Observable.fromIterable(() -> {
            try {
                return Files.walk(pPath, new FileVisitOption[0]).filter(t -> t.toString().endsWith(PROPERTY_EXTENSION)).iterator();
            }
            catch (IOException ex) {
                return Collections.emptyIterator();
            }
        }).map(fullPath -> new Tuple<Path, Path>(pPath, (Path)fullPath));
    }

    protected Map<String, ListMultimap<String, ValueWithModifier>> getPropertiesCache() {
        return this.mPropertiesRepository;
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void setInitialized(boolean initialized) {
        this.mInitialized = initialized;
    }

    public static List<String> getLayers() {
        return layers;
    }

    public static void setLayers(List<String> pLayer) {
        layers = pLayer.stream().map(path -> {
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                try {
                    String dir = Util.unzip(Paths.get(path, new String[0]), Files.createTempDirectory("layer", new FileAttribute[0]));
                    Object[] configFolder = Files.walk(Paths.get(dir, new String[0]), new FileVisitOption[0]).filter(p -> p.endsWith("config")).limit(1L).toArray();
                    if (configFolder.length > 0) {
                        return ((Path)configFolder[0]).toString();
                    }
                    return null;
                }
                catch (IOException ex) {
                    LogManager.getLogger((String)PropertiesRepository.class.getCanonicalName()).error(path);
                }
            }
            return path;
        }).filter(path -> !Strings.isNullOrEmpty((String)path)).collect(Collectors.toList());
    }

    public String toString() {
        MoreObjects.ToStringHelper obj = MoreObjects.toStringHelper((Object)this);
        this.mPropertiesRepository.entrySet().stream().forEach(t -> obj.add((String)t.getKey(), (Object)((ListMultimap)t.getValue()).toString()));
        return obj.toString();
    }

    private static /* synthetic */ void lambda$updateBasedOnProperties$19(ListMultimap newProperties, Map.Entry e) {
        newProperties.put(e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$updateBasedOnProperties$17(ListMultimap newProperties, Map.Entry e) {
        newProperties.put(e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$updateBasedOnSpecialProperties$16(ListMultimap newProperties, Map.Entry e) {
        newProperties.put(e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$updateBasedOnSpecialProperties$14(ListMultimap newProperties, Map.Entry e) {
        String key = (String)e.getKey();
        key = "$class".equals(key) ? "baseClass" : key.substring(1);
        String k = Util.convertDotToCamelCase(key);
        newProperties.put((Object)k, e.getValue());
    }

    static {
        COMPONENT_PATH_REGEX = Pattern.compile("^(?<path>.*)\\.properties$");
    }
}

