/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import in.erail.glue.ConfigSerializationFactory;
import in.erail.glue.common.ValueWithModifier;
import in.erail.glue.enumeration.PropertyValueModifier;
import in.erail.glue.factory.DefaultConfigSerializationFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private static final Logger LOGGER = LogManager.getLogger((String)Util.class.getCanonicalName());
    private static final MetricRegistry METRIC_REGISTRY;
    private static final Properties GLUE_CONFIG;

    public static boolean isOSWindows() {
        return IS_WINDOWS;
    }

    public static String buildSetPropertyName(String pProperty) {
        return "set" + pProperty.substring(0, 1).toUpperCase() + pProperty.substring(1, pProperty.length());
    }

    public static String buildGetPropertyName(String pProperty, boolean pIsBoolean) {
        if (pIsBoolean) {
            return "is" + pProperty.substring(0, 1).toUpperCase() + pProperty.substring(1, pProperty.length());
        }
        return "get" + pProperty.substring(0, 1).toUpperCase() + pProperty.substring(1, pProperty.length());
    }

    public static Method getMethod(Class pClass, String pMethodName) {
        Method[] methods;
        LOGGER.debug(() -> "Trying to find Method:" + pMethodName + " in class:" + pClass.getCanonicalName());
        for (Method method : methods = pClass.getMethods()) {
            if (!method.getName().equals(pMethodName)) continue;
            LOGGER.debug(() -> "Found Method:" + pMethodName + " in class:" + pClass.getCanonicalName());
            return method;
        }
        LOGGER.debug(() -> "Not Found Method:" + pMethodName + " in class:" + pClass.getCanonicalName());
        return null;
    }

    public static <T extends Annotation> Method getMethodWithAnnotation(Class pClass, Class<T> pAnnotation) {
        Method[] methods;
        for (Method method : methods = pClass.getMethods()) {
            T anno = method.getAnnotation(pAnnotation);
            if (anno == null) continue;
            return method;
        }
        return null;
    }

    public static Class getMethodFirstArgumentClass(Method pMethod) {
        Parameter[] param = pMethod.getParameters();
        if (param.length == 0) {
            throw new RuntimeException("No arguments in method:" + pMethod.getName());
        }
        return param[0].getType();
    }

    public static Object createInstance(String pClass) {
        Object inst = null;
        try {
            Class<?> clzz = Class.forName(pClass);
            inst = clzz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return inst;
    }

    public static Object createInstance(Class<?> pClass) {
        Object inst = null;
        try {
            inst = pClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return inst;
    }

    public static Map<String, String> getMapFromValue(String pValue) {
        if (Strings.isNullOrEmpty((String)pValue)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : Util.convertCSVIntoArray(pValue)) {
            String[] keyvalue = s.split("=");
            result.put(keyvalue[0], keyvalue[1]);
        }
        return result;
    }

    public static MetricRegistry getMetricRegistry() {
        return METRIC_REGISTRY;
    }

    public static String getEnvironmentValue(String pName, String pDefault) {
        String value = System.getProperty(pName);
        if (Strings.isNullOrEmpty((String)value)) {
            value = System.getenv(pName.toUpperCase().replace(".", "_"));
        }
        if (Strings.isNullOrEmpty((String)value)) {
            value = GLUE_CONFIG.getProperty(pName);
        }
        if (Strings.isNullOrEmpty((String)value)) {
            return pDefault;
        }
        return value;
    }

    public static String getEnvironmentValue(String pName) {
        return Util.getEnvironmentValue(pName, null);
    }

    public static ConfigSerializationFactory getConfigSerializationFactory() {
        String factory = Util.getEnvironmentValue("glue.serialization.factory");
        if (Strings.isNullOrEmpty((String)factory)) {
            return new DefaultConfigSerializationFactory();
        }
        return (ConfigSerializationFactory)Util.createInstance(factory);
    }

    public static List<String> getSystemLayers() {
        String layer = Util.getEnvironmentValue("glue.layers");
        if (layer == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(layer.split(","));
    }

    public static ValueWithModifier getLastValueWithModifier(Collection<ValueWithModifier> pList) {
        if (pList.isEmpty()) {
            return new ValueWithModifier(null, PropertyValueModifier.NONE);
        }
        List v = (List)pList;
        return (ValueWithModifier)v.get(v.size() - 1);
    }

    public static String getLastValue(ListMultimap<String, ValueWithModifier> pMap, String pPropertyName) {
        if (pMap == null) {
            LOGGER.error("Value map expected for property:" + pPropertyName);
            return null;
        }
        return Util.getLastValueWithModifier(pMap.get((Object)pPropertyName)).getValue();
    }

    public static String getLastValue(ListMultimap<String, ValueWithModifier> pMap, String pPropertyName, String pDefault) {
        String result = Util.getLastValue(pMap, pPropertyName);
        if (result == null) {
            return pDefault;
        }
        return result;
    }

    public static String unzip(Path pZipFilePath, Path pDestinationPath) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(pZipFilePath.toFile()));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String uri = pDestinationPath + File.separator + entry.getName();
                Path path = Paths.get(uri, new String[0]);
                if (entry.isDirectory()) {
                    if (!Files.exists(path, new LinkOption[0])) {
                        Files.createDirectories(path, new FileAttribute[0]);
                    }
                } else {
                    Path parentPath = path.getParent();
                    if (!Files.exists(parentPath, new LinkOption[0])) {
                        Files.createDirectories(parentPath, new FileAttribute[0]);
                    }
                    Files.copy(zipIn, path, new CopyOption[0]);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            String string = pDestinationPath.toString();
            return string;
        }
    }

    public static String convertDotToCamelCase(String pValue) {
        StringBuilder sb = new StringBuilder(pValue);
        int dotIndx = 0;
        while (dotIndx != -1 && (dotIndx = sb.indexOf(".")) != -1) {
            sb.deleteCharAt(dotIndx);
            sb.setCharAt(dotIndx, Character.toUpperCase(sb.charAt(dotIndx)));
        }
        return sb.toString();
    }

    public static String[] convertCSVIntoArray(String pValue) {
        try {
            CSVParser parser = CSVParser.parse((String)pValue, (CSVFormat)CSVFormat.DEFAULT);
            Iterator itrRecord = parser.iterator();
            if (itrRecord.hasNext()) {
                CSVRecord record = (CSVRecord)itrRecord.next();
                String[] result = new String[record.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = record.get(i);
                }
                return result;
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
        }
        return new String[0];
    }

    static {
        GLUE_CONFIG = new Properties();
        String metricRegistryName = Util.getEnvironmentValue("metric.registry.name");
        if (metricRegistryName == null) {
            metricRegistryName = "vertx-registry";
        }
        METRIC_REGISTRY = SharedMetricRegistries.getOrCreate((String)metricRegistryName);
        Path glueConfig = Paths.get(Util.getEnvironmentValue("glue.config", "glue.config"), new String[0]);
        if (Files.exists(glueConfig, new LinkOption[0])) {
            try {
                GLUE_CONFIG.load(Files.newInputStream(glueConfig, new OpenOption[0]));
            }
            catch (IOException ex) {
                LOGGER.error("Not able to load glue.config from " + glueConfig.toString(), (Throwable)ex);
            }
        } else {
            LOGGER.info(glueConfig.toAbsolutePath().toString() + " not found. User Dir:" + System.getProperty("user.dir"));
        }
    }
}

