/*
 * Decompiled with CFR 0.152.
 */
package in.erail.glue.factory;

import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import in.erail.glue.ConfigSerializationFactory;
import in.erail.glue.PropertiesRepository;
import in.erail.glue.common.Util;
import in.erail.glue.common.ValueWithModifier;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalConfigSerializationFactory
implements ConfigSerializationFactory {
    public static final String ENV_FILE_LOCATION = "local.config.factory.file.location";
    public static final String ENV_FILE_NAME = "local.config.factory.file.name";
    public static final String ENV_IDENTIFIER = "local.config.factory.identifier";
    public static final String ENV_DISABLE_SAVE = "local.config.factory.disable.save";
    private static final String DEFAULT_FILE_LOCATION = "";
    private static final String DEFAULT_FILE_NAME = "glue.ser";
    private static final String DEFAULT_DISABLE_SAVE = "false";
    private final Logger log = LogManager.getLogger((String)LocalConfigSerializationFactory.class.getCanonicalName());
    private final String mFileLocation = Util.getEnvironmentValue("local.config.factory.file.location", "");
    private final String mFileName = Util.getEnvironmentValue("local.config.factory.file.name", "glue.ser");
    private final String mIdentifier = Util.getEnvironmentValue("local.config.factory.identifier", ".default");
    private final boolean mSaveDisabled = Boolean.parseBoolean(Util.getEnvironmentValue("local.config.factory.disable.save", "false"));

    @Override
    public Completable save(Map<String, ListMultimap<String, ValueWithModifier>> pConfig) {
        return this.save(pConfig, this.mIdentifier);
    }

    @Override
    public Completable save(Map<String, ListMultimap<String, ValueWithModifier>> pConfig, String pIdentifier) {
        if (this.mSaveDisabled) {
            return Completable.complete();
        }
        Path fileLocation = Paths.get(this.mFileLocation, this.mFileName + pIdentifier);
        return Single.just((Object)fileLocation).subscribeOn(Schedulers.io()).flatMapCompletable(location -> {
            try (FileOutputStream file = new FileOutputStream(location.toFile());
                 ObjectOutputStream output = new ObjectOutputStream(file);){
                output.writeObject(pConfig);
                this.log.debug("Done writing");
            }
            catch (IOException err) {
                return Completable.error((Throwable)err);
            }
            return Completable.complete();
        });
    }

    @Override
    public Maybe<Map<String, ListMultimap<String, ValueWithModifier>>> load() {
        return this.load(this.mIdentifier);
    }

    @Override
    public Maybe<Map<String, ListMultimap<String, ValueWithModifier>>> load(String pIdentifier) {
        Path fileLocation = Paths.get(this.mFileLocation, this.mFileName + pIdentifier);
        return Maybe.just((Object)fileLocation).subscribeOn(Schedulers.io()).flatMap(location -> {
            this.log.debug("Reading....");
            try (FileInputStream file = new FileInputStream(location.toFile());){
                Maybe maybe;
                try (ObjectInputStream input = new ObjectInputStream(file);){
                    Map result = (Map)input.readObject();
                    this.log.info(() -> "Config loaded from : " + location.toString());
                    maybe = Maybe.just((Object)result);
                }
                return maybe;
            }
            catch (IOException | ClassNotFoundException ex) {
                this.log.info(() -> "Not able to load config from : " + location.toString());
                this.log.debug((Object)ex);
                return Maybe.empty();
            }
        });
    }

    public static void main(String[] pArgs) {
        String factory = System.getProperty("glue.serialization.factory");
        boolean removeFactoryProperty = false;
        if (Strings.isNullOrEmpty((String)factory)) {
            System.setProperty("glue.serialization.factory", LocalConfigSerializationFactory.class.getCanonicalName());
            removeFactoryProperty = true;
        } else if (!LocalConfigSerializationFactory.class.getCanonicalName().equals(factory)) {
            throw new RuntimeException("Incorrect Serialization Factory Set:" + factory);
        }
        PropertiesRepository.setLayers(Util.getSystemLayers());
        new PropertiesRepository().init();
        if (removeFactoryProperty) {
            System.clearProperty("glue.serialization.factory");
        }
    }
}

