/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18N {
    protected static final String FORMAT = "${package}._Bundle";
    public static final String BASENAME = "Bundle";

    public static <T> T getImplementation(Class<T> bundleClass) {
        try {
            String qname = FORMAT.replace("${package}", bundleClass.getPackage() != null ? bundleClass.getPackage().getName() : "").replace("${class}", bundleClass.getSimpleName());
            if (qname.startsWith(".")) {
                qname = qname.substring(1);
            }
            Class<?> implementation = bundleClass.getClassLoader().loadClass(qname);
            return (T)implementation.getDeclaredField("INSTANCE").get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ResourceBundle bundle(Class clazz) {
        return ResourceBundle.getBundle(clazz.getPackage().getName().replace('.', '/') + "/" + BASENAME);
    }

    public static String getValue(Class clazz, String key, Object ... args) {
        try {
            return MessageFormat.format(I18N.bundle(clazz).getString(key), args);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String getHint(Class clazz, String member, String hint, Object ... args) {
        return I18N.getValue(clazz, clazz.getSimpleName() + '.' + member + '.' + hint, args);
    }

    public static String getHint(Class clazz, String hint, Object ... args) {
        return I18N.getValue(clazz, clazz.getSimpleName() + '.' + hint, args);
    }
}

