/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.PaymentMethodList;
import in.juspay.model.RequestOptions;

public class PaymentMethod
extends JuspayEntity {
    String paymentMethodType;
    String paymentMethod;
    String description;

    public static PaymentMethodList list(String merchantId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return PaymentMethod.list(merchantId, null);
    }

    public static PaymentMethodList list(String merchantId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (merchantId == null || merchantId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = PaymentMethod.makeServiceCall("/merchants/" + merchantId + "/paymentmethods", null, JuspayEntity.RequestMethod.GET, requestOptions);
        return PaymentMethod.createEntityFromResponse((JsonElement)response, PaymentMethodList.class);
    }

    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

