package in.juspay.model;

public class RequestOptions {
    private String apiKey;
    private int connectTimeoutInMilliSeconds;
    private int readTimeoutInMilliSeconds;

    private RequestOptions() {
        apiKey = JuspayEnvironment.getApiKey();
        connectTimeoutInMilliSeconds = JuspayEnvironment.getConnectTimeoutInMilliSeconds();
        readTimeoutInMilliSeconds = JuspayEnvironment.getReadTimeoutInMilliSeconds();
    }

    public static RequestOptions createDefault() {
        return new RequestOptions();
    }

    public String getApiKey() {
        return apiKey;
    }

    public RequestOptions withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public int getConnectTimeoutInMilliSeconds() {
        return connectTimeoutInMilliSeconds;
    }

    public RequestOptions withConnectTimeout(int connectTimeout) {
        this.connectTimeoutInMilliSeconds = connectTimeout;
        return this;
    }

    public int getReadTimeoutInMilliSeconds() {
        return readTimeoutInMilliSeconds;
    }

    public RequestOptions withReadTimeout(int readTimeout) {
        this.readTimeoutInMilliSeconds = readTimeout;
        return this;
    }
}
