/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import in.juspay.model.WalletList;
import java.util.Date;

public class Wallet
extends JuspayEntity {
    private String id;
    private String object;
    private String wallet;
    private String token;
    private Double currentBalance;
    private Date lastRefreshed;

    public static WalletList list(String customerId) throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        return Wallet.list(customerId, null);
    }

    public static WalletList list(String customerId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        if (customerId == null || customerId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = Wallet.makeServiceCall("/customers/" + customerId + "/wallets", null, JuspayEntity.RequestMethod.GET, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, WalletList.class);
    }

    public static WalletList refresh(String customerId) throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        return Wallet.refresh(customerId, null);
    }

    public static WalletList refresh(String customerId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        if (customerId == null || customerId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = Wallet.makeServiceCall("/customers/" + customerId + "/wallets/refresh-balances", null, JuspayEntity.RequestMethod.GET, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, WalletList.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getWallet() {
        return this.wallet;
    }

    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Double getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(Double currentBalance) {
        this.currentBalance = currentBalance;
    }

    public Date getLastRefreshed() {
        return this.lastRefreshed;
    }

    public void setLastRefreshed(Date lastRefreshed) {
        this.lastRefreshed = lastRefreshed;
    }
}

