package in.juspay.model;

import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.InvalidRequestException;

public class PaymentMethod extends JuspayEntity {

    String paymentMethodType;
    String paymentMethod;
    String description;

    public static PaymentMethodList list(String merchantId)
            throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        return list(merchantId, null);
    }

    public static PaymentMethodList list(String merchantId, RequestOptions requestOptions)
            throws APIException, APIConnectionException, AuthenticationException, InvalidRequestException {
        if (merchantId == null || merchantId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = makeServiceCall("/merchants/" + merchantId + "/paymentmethods", null, RequestMethod.GET, requestOptions);
        return createEntityFromResponse(response, PaymentMethodList.class);
    }

    public String getPaymentMethodType() {return paymentMethodType;}

    public void setPaymentMethodType(String paymentMethodType) {this.paymentMethodType = paymentMethodType;}

    public String getPaymentMethod() {return paymentMethod;}

    public void setPaymentMethod(String paymentMethod) {this.paymentMethod = paymentMethod;}

    public String getDescription() {return description;}

    public void setDescription(String description) {this.description = description;}
}
