/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.CustomerList;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer
extends JuspayEntity {
    private String id;
    private String object;
    private String firstName;
    private String lastName;
    private String mobileCountryCode;
    private String mobileNumber;
    private String emailAddress;
    private Date dateCreated;
    private Date lastUpdated;
    private String objectReferenceId;

    public static Customer create(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Customer.create(params, null);
    }

    public static Customer create(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Customer.makeServiceCall("/customers", params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Customer.createEntityFromResponse((JsonElement)response, Customer.class);
    }

    public static Customer update(String id, Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Customer.update(id, params, null);
    }

    public static Customer update(String id, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (id == null || id.equals("") || params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Customer.makeServiceCall("/customers/" + id, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Customer.createEntityFromResponse((JsonElement)response, Customer.class);
    }

    public static CustomerList list(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Customer.list(params, null);
    }

    public static CustomerList list(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        JsonObject response = Customer.makeServiceCall("/customers", params, JuspayEntity.RequestMethod.GET, requestOptions);
        return Customer.createEntityFromResponse((JsonElement)response, CustomerList.class);
    }

    public static Customer get(String id) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Customer.get(id, null);
    }

    public static Customer get(String id, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (id == null || id.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = Customer.makeServiceCall("/customers/" + id, null, JuspayEntity.RequestMethod.GET, requestOptions);
        return Customer.createEntityFromResponse((JsonElement)response, Customer.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMobileCountryCode() {
        return this.mobileCountryCode;
    }

    public void setMobileCountryCode(String mobileCountryCode) {
        this.mobileCountryCode = mobileCountryCode;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public String getObjectReferenceId() {
        return this.objectReferenceId;
    }

    public void setObjectReferenceId(String objectReferenceId) {
        this.objectReferenceId = objectReferenceId;
    }
}

