/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.Card;
import in.juspay.model.Chargeback;
import in.juspay.model.JuspayEntity;
import in.juspay.model.JuspayOptions;
import in.juspay.model.Mandate;
import in.juspay.model.Offer;
import in.juspay.model.OrderList;
import in.juspay.model.PaymentGatewayResponse;
import in.juspay.model.PaymentLinks;
import in.juspay.model.Refund;
import in.juspay.model.RequestOptions;
import in.juspay.model.SecondFactorResponse;
import in.juspay.model.TxnDetail;
import in.juspay.model.TxnDetailList;
import in.juspay.model.TxnFlowInfo;
import in.juspay.model.TxnOfferInfo;
import in.juspay.model.Upi;
import in.juspay.model.WalletTopup;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order
extends JuspayEntity {
    private String id;
    private String orderId;
    private String merchantId;
    private String txnId;
    private Double amount;
    private Double effectiveAmount;
    private String respCode;
    private String respMessage;
    private String currency;
    private String customerId;
    private String customerEmail;
    private String customerPhone;
    private String description;
    private String productId;
    private Long gatewayId;
    private String returnUrl;
    private String udf1;
    private String udf2;
    private String udf3;
    private String udf4;
    private String udf5;
    private String udf6;
    private String udf7;
    private String udf8;
    private String udf9;
    private String udf10;
    private String status;
    private Long statusId;
    private Boolean refunded;
    private Double amountRefunded;
    private String bankErrorCode;
    private String bankErrorMessage;
    private String paymentMethod;
    private String paymentMethodType;
    private String payerVpa;
    private String payerAppName;
    private String gatewayReferenceId;
    private String authType;
    private String gatewayPayload;
    private Card card;
    private Upi upi;
    private PaymentGatewayResponse paymentGatewayResponse;
    private PaymentLinks paymentLinks;
    private TxnDetail txnDetail;
    private TxnOfferInfo offer;
    private List<Offer> offers;
    private List<Refund> refunds;
    private List<Chargeback> chargebacks;
    private Mandate mandate;
    private JuspayOptions juspay;
    private TxnFlowInfo txnFlowInfo;
    private SecondFactorResponse secondFactorResponse;
    private WalletTopup wallet;

    public static Order create(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.create(params, null);
    }

    public static Order create(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Order.makeServiceCall("/orders", params, JuspayEntity.RequestMethod.POST, requestOptions);
        response = Order.addInputParamsToResponse(params, response);
        return Order.createEntityFromResponse((JsonElement)response, Order.class);
    }

    public static Order status(String orderId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.status(orderId, null, null);
    }

    public static Order status(String orderId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.status(orderId, null, requestOptions);
    }

    public static Order status(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        String orderId = (String)params.get("order_id");
        if (orderId == null) {
            throw new InvalidRequestException();
        }
        return Order.status(orderId, params, null);
    }

    public static Order status(String orderId, Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.status(orderId, params, null);
    }

    public static Order status(String orderId, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (orderId == null || orderId.equals("")) {
            throw new InvalidRequestException();
        }
        if (params == null) {
            params = new LinkedHashMap<String, Object>();
        }
        params.put("order_id", orderId);
        String path = Order.getEncryptionMethodBasedOnConfig(requestOptions) == JuspayEntity.AuthMethod.JWE_JWS ? "/v4/order-status" : "/orders/" + orderId;
        JsonObject response = Order.makeServiceCallWithAuthDecider(path, params, JuspayEntity.RequestMethod.GET, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, Order.class);
    }

    public static Order update(String orderId, Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.update(orderId, params, null);
    }

    public static Order update(String orderId, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (orderId == null || orderId.equals("") || params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Order.makeServiceCall("/orders/" + orderId, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, Order.class);
    }

    @Deprecated
    public static OrderList list(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.list(params, null);
    }

    @Deprecated
    public static OrderList list(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        JsonObject response = Order.makeServiceCall("/orders", params, JuspayEntity.RequestMethod.GET, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, OrderList.class);
    }

    public static TxnDetailList listTxns(String orderId, Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.listTxns(orderId, params, null);
    }

    public static TxnDetailList listTxns(String orderId, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        JsonObject response = Order.makeServiceCall("/orders/" + orderId + "/txns", params, JuspayEntity.RequestMethod.GET, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, TxnDetailList.class);
    }

    public static Order refund(String orderId, Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.refund(orderId, params, null);
    }

    public static Order refund(String orderId, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (orderId == null || orderId.equals("") || params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        String path = Order.getEncryptionMethodBasedOnConfig(requestOptions) == JuspayEntity.AuthMethod.JWE_JWS ? "/v4/orders/" + orderId + "/refunds" : "/orders/" + orderId + "/refunds";
        JsonObject response = Order.makeServiceCallWithAuthDecider(path, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, Order.class);
    }

    public static Refund refund(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Order.refund(params, null);
    }

    public static Refund refund(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        JsonObject response = Order.makeServiceCall("/refunds", params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Order.createEntityFromResponse((JsonElement)response, Refund.class);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Long getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(Long gatewayId) {
        this.gatewayId = gatewayId;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getUdf1() {
        return this.udf1;
    }

    public void setUdf1(String udf1) {
        this.udf1 = udf1;
    }

    public String getUdf2() {
        return this.udf2;
    }

    public void setUdf2(String udf2) {
        this.udf2 = udf2;
    }

    public String getUdf3() {
        return this.udf3;
    }

    public void setUdf3(String udf3) {
        this.udf3 = udf3;
    }

    public String getUdf4() {
        return this.udf4;
    }

    public void setUdf4(String udf4) {
        this.udf4 = udf4;
    }

    public String getUdf5() {
        return this.udf5;
    }

    public void setUdf5(String udf5) {
        this.udf5 = udf5;
    }

    public String getUdf6() {
        return this.udf6;
    }

    public void setUdf6(String udf6) {
        this.udf6 = udf6;
    }

    public String getUdf7() {
        return this.udf7;
    }

    public void setUdf7(String udf7) {
        this.udf7 = udf7;
    }

    public String getUdf8() {
        return this.udf8;
    }

    public void setUdf8(String udf8) {
        this.udf8 = udf8;
    }

    public String getUdf9() {
        return this.udf9;
    }

    public void setUdf9(String udf9) {
        this.udf9 = udf9;
    }

    public String getUdf10() {
        return this.udf10;
    }

    public void setUdf10(String udf10) {
        this.udf10 = udf10;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getStatusId() {
        return this.statusId;
    }

    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public Double getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Double amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getBankErrorCode() {
        return this.bankErrorCode;
    }

    public void setBankErrorCode(String bankErrorCode) {
        this.bankErrorCode = bankErrorCode;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getPaymentMethodType() {
        return this.paymentMethodType;
    }

    public void setPaymentMethodType(String paymentMethodType) {
        this.paymentMethodType = paymentMethodType;
    }

    public String getBankErrorMessage() {
        return this.bankErrorMessage;
    }

    public void setBankErrorMessage(String bankErrorMessage) {
        this.bankErrorMessage = bankErrorMessage;
    }

    public String getGatewayReferenceId() {
        return this.gatewayReferenceId;
    }

    public void setGatewayReferenceId(String gatewayReferenceId) {
        this.gatewayReferenceId = gatewayReferenceId;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getGatewayPayload() {
        return this.gatewayPayload;
    }

    public void setGatewayPayload(String gatewayPayload) {
        this.gatewayPayload = gatewayPayload;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public PaymentGatewayResponse getPaymentGatewayResponse() {
        return this.paymentGatewayResponse;
    }

    public void setPaymentGatewayResponse(PaymentGatewayResponse paymentGatewayResponse) {
        this.paymentGatewayResponse = paymentGatewayResponse;
    }

    public List<Refund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    public PaymentLinks getPaymentLinks() {
        return this.paymentLinks;
    }

    public void setPaymentLinks(PaymentLinks paymentLinks) {
        this.paymentLinks = paymentLinks;
    }

    public TxnDetail getTxnDetail() {
        return this.txnDetail;
    }

    public void setTxnDetail(TxnDetail txnDetail) {
        this.txnDetail = txnDetail;
    }

    public TxnOfferInfo getOffer() {
        return this.offer;
    }

    public void setOffer(TxnOfferInfo offer) {
        this.offer = offer;
    }

    public List<Offer> getOffers() {
        return this.offers;
    }

    public void setOffers(List<Offer> offers) {
        this.offers = offers;
    }

    public List<Chargeback> getChargebacks() {
        return this.chargebacks;
    }

    public void setChargebacks(List<Chargeback> chargebacks) {
        this.chargebacks = chargebacks;
    }

    public Mandate getMandate() {
        return this.mandate;
    }

    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public JuspayOptions getJuspayOptions() {
        return this.juspay;
    }

    public void setJuspayOptions(JuspayOptions juspayOptions) {
        this.juspay = juspayOptions;
    }

    public String getPayerVpa() {
        return this.payerVpa;
    }

    public void setPayerVpa(String payerVpa) {
        this.payerVpa = payerVpa;
    }

    public String getPayerAppName() {
        return this.payerAppName;
    }

    public void setPayerAppName(String payerAppName) {
        this.payerAppName = payerAppName;
    }

    public TxnFlowInfo getTxnFlowInfo() {
        return this.txnFlowInfo;
    }

    public void setTxnFlowInfo(TxnFlowInfo txnFlowInfo) {
        this.txnFlowInfo = txnFlowInfo;
    }

    public SecondFactorResponse getSecondFactorResponse() {
        return this.secondFactorResponse;
    }

    public void setSecondFactorResponse(SecondFactorResponse secondFactorResponse) {
        this.secondFactorResponse = secondFactorResponse;
    }

    public Upi getUpi() {
        return this.upi;
    }

    public void setUpi(Upi upi) {
        this.upi = upi;
    }

    public Double getEffectiveAmount() {
        return this.effectiveAmount;
    }

    public void setEffectiveAmount(Double effectiveAmount) {
        this.effectiveAmount = effectiveAmount;
    }

    public String getRespCode() {
        return this.respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMessage() {
        return this.respMessage;
    }

    public void setRespMessage(String respMessage) {
        this.respMessage = respMessage;
    }

    public WalletTopup getWallet() {
        return this.wallet;
    }

    public void setWallet(WalletTopup wallet) {
        this.wallet = wallet;
    }
}

