/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import in.juspay.model.JuspayEnvironment;
import in.juspay.model.JweJwsEncryptionKeys;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestOptions {
    private String apiKey = JuspayEnvironment.getApiKey();
    private String merchantId = JuspayEnvironment.getMerchantId();
    private String apiVersion = "2019-05-07";
    private int connectTimeoutInMilliSeconds = JuspayEnvironment.getConnectTimeoutInMilliSeconds();
    private int readTimeoutInMilliSeconds = JuspayEnvironment.getReadTimeoutInMilliSeconds();
    private JweJwsEncryptionKeys jweJwsEncryptionKeys = JuspayEnvironment.getJweJwsEncryptionKeys();
    private Map<String, String> headers = new LinkedHashMap<String, String>();

    private RequestOptions() {
    }

    public static RequestOptions createDefault() {
        return new RequestOptions();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public RequestOptions withMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public RequestOptions withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public int getConnectTimeoutInMilliSeconds() {
        return this.connectTimeoutInMilliSeconds;
    }

    public RequestOptions withConnectTimeout(int connectTimeout) {
        this.connectTimeoutInMilliSeconds = connectTimeout;
        return this;
    }

    public int getReadTimeoutInMilliSeconds() {
        return this.readTimeoutInMilliSeconds;
    }

    public RequestOptions withReadTimeout(int readTimeout) {
        this.readTimeoutInMilliSeconds = readTimeout;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public RequestOptions withApiVersion(String version) {
        this.apiVersion = version;
        return this;
    }

    public RequestOptions withJweJwsEncryption(JweJwsEncryptionKeys encryption) {
        this.jweJwsEncryptionKeys = encryption;
        return this;
    }

    public JweJwsEncryptionKeys getJweJwsEncryptionKeys() {
        return this.jweJwsEncryptionKeys;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeaders(String key) {
        return this.headers.get(key);
    }

    public RequestOptions withHeaders(Map<String, String> val) {
        if (val != null) {
            this.headers = val;
        }
        return this;
    }

    public RequestOptions withHeaders(String key, String val) {
        if (key != null && val != null && val.length() != 0 && key.length() != 0) {
            this.headers.put(key, val);
        }
        return this;
    }
}

