package in.juspay.model;

import com.google.gson.JsonObject;
import in.juspay.exception.*;

import java.util.LinkedHashMap;
import java.util.Map;

public class OrderSession extends JuspayEntity{
    private SessionApiPaymentLinks paymentLinks;

    private String orderId;

    private String status;

    private Map<String, Object> sdkPayload;

    private String id;

    private String expiry;

    public static OrderSession create(Map<String, Object> params)
            throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return create(params, null);
    }

    public static OrderSession create(Map<String, Object> params, RequestOptions requestOptions)
            throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        if(requestOptions == null) {
            requestOptions = RequestOptions.createDefault();
        }
        requestOptions.withHeaders("Content-Type", "application/json");
        String path = getEncryptionMethodBasedOnConfig(requestOptions) == AuthMethod.JWE_JWS ? "/v4/session" : "/session";
        JsonObject response = makeServiceCallWithAuthDecider(path, params, RequestMethod.POST, requestOptions);
        response = addInputParamsToResponse(params, response);
        return createEntityFromResponse(response, OrderSession.class);
    }

    public SessionApiPaymentLinks getPaymentLinks() {
        return this.paymentLinks;
    }
    public void setPaymentLinks(SessionApiPaymentLinks paymentLinks) {
        this.paymentLinks = paymentLinks;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, Object> getSdkPayload() {
        return this.sdkPayload;
    }

    public void setSdkPayload(Map<String, Object> sdkPayload) {
        this.sdkPayload = sdkPayload;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }
}
