/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import in.juspay.model.Token;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Card
extends JuspayEntity {
    private String cardNumber;
    private String nameOnCard;
    private String cardExpYear;
    private String cardExpMonth;
    private String expiryMonth;
    private String expiryYear;
    private String cardSecurityCode;
    private String nickname;
    private String cardToken;
    private String cardReference;
    private String cardFingerprint;
    private String cardIsin;
    private String lastFourDigits;
    private String cardType;
    private String cardIssuer;
    private Boolean savedToLocker;
    private Boolean expired;
    private String cardBrand;
    private Double cardBalance;
    private Boolean usingSavedCard;
    private String cardSubType;
    private String cardIssuerCountry;
    private String juspayBankCode;
    private Boolean usingToken;
    private Boolean tokenizationUserConsent;
    private Boolean tokenizeSupport;
    private String providerCategory;
    private String provider;
    private Token token;
    private Map<String, Object> metadata;

    public static Card create(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Card.create(params, null);
    }

    public static Card create(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Card.makeServiceCall("/cards", params, JuspayEntity.RequestMethod.POST, requestOptions);
        response = Card.addInputParamsToResponse(params, response);
        return Card.createEntityFromResponse((JsonElement)response, Card.class);
    }

    public static List<Card> list(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Card.list(params, null);
    }

    public static List<Card> list(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        JsonObject response = Card.makeServiceCall("/cards", params, JuspayEntity.RequestMethod.GET, requestOptions);
        ArrayList<Card> cardList = new ArrayList<Card>();
        if (response.has("cards")) {
            JsonArray cardArray = response.get("cards").getAsJsonArray();
            for (int i = 0; i < cardArray.size(); ++i) {
                cardList.add(Card.createEntityFromResponse(cardArray.get(i), Card.class));
            }
        }
        return cardList;
    }

    public static boolean delete(String cardToken) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Card.delete(cardToken, null);
    }

    public static boolean delete(String cardToken, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (cardToken == null || cardToken.length() == 0) {
            throw new InvalidRequestException();
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("card_token", cardToken);
        JsonObject response = Card.makeServiceCall("/card/delete", params, JuspayEntity.RequestMethod.POST, requestOptions);
        return response.get("deleted").getAsBoolean();
    }

    public Boolean getSavedToLocker() {
        return this.savedToLocker;
    }

    public void setSavedToLocker(Boolean savedToLocker) {
        this.savedToLocker = savedToLocker;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    public String getCardExpYear() {
        if (this.expiryYear != null) {
            return this.expiryYear;
        }
        return this.cardExpYear;
    }

    public void setCardExpYear(String cardExpYear) {
        this.cardExpYear = cardExpYear;
    }

    public String getCardExpMonth() {
        if (this.expiryMonth != null) {
            return this.expiryMonth;
        }
        return this.cardExpMonth;
    }

    public void setCardExpMonth(String cardExpMonth) {
        this.cardExpMonth = cardExpMonth;
    }

    public String getCardSecurityCode() {
        return this.cardSecurityCode;
    }

    public void setCardSecurityCode(String cardSecurityCode) {
        this.cardSecurityCode = cardSecurityCode;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getCardToken() {
        return this.cardToken;
    }

    public void setCardToken(String cardToken) {
        this.cardToken = cardToken;
    }

    public String getCardReference() {
        return this.cardReference;
    }

    public void setCardReference(String cardReference) {
        this.cardReference = cardReference;
    }

    public String getCardFingerprint() {
        return this.cardFingerprint;
    }

    public void setCardFingerprint(String cardFingerprint) {
        this.cardFingerprint = cardFingerprint;
    }

    public String getCardIsin() {
        return this.cardIsin;
    }

    public void setCardIsin(String cardIsin) {
        this.cardIsin = cardIsin;
    }

    public String getLastFourDigits() {
        return this.lastFourDigits;
    }

    public void setLastFourDigits(String lastFourDigits) {
        this.lastFourDigits = lastFourDigits;
    }

    public String getCardType() {
        return this.cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getCardIssuer() {
        return this.cardIssuer;
    }

    public void setCardIssuer(String cardIssuer) {
        this.cardIssuer = cardIssuer;
    }

    public Boolean getExpired() {
        return this.expired;
    }

    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    public String getCardBrand() {
        return this.cardBrand;
    }

    public void setCardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
    }

    public Double getCardBalance() {
        return this.cardBalance;
    }

    public void setCardBalance(Double cardBalance) {
        this.cardBalance = cardBalance;
    }

    public Boolean getUsingSavedCard() {
        return this.usingSavedCard;
    }

    public void setUsingSavedCard(Boolean usingSavedCard) {
        this.usingSavedCard = usingSavedCard;
    }

    public String getExpiryMonth() {
        if (this.cardExpMonth != null) {
            return this.cardExpMonth;
        }
        return this.expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public String getExpiryYear() {
        if (this.cardExpYear != null) {
            return this.cardExpYear;
        }
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public String getCardSubType() {
        return this.cardSubType;
    }

    public void setCardSubType(String cardSubType) {
        this.cardSubType = cardSubType;
    }

    public Boolean getTokenizationUserConsent() {
        return this.tokenizationUserConsent;
    }

    public void setTokenizationUserConsent(Boolean tokenizationUserConsent) {
        this.tokenizationUserConsent = tokenizationUserConsent;
    }

    public Boolean getUsingToken() {
        return this.usingToken;
    }

    public void setUsingToken(Boolean usingToken) {
        this.usingToken = usingToken;
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProviderCategory() {
        return this.providerCategory;
    }

    public void setProviderCategory(String providerCategory) {
        this.providerCategory = providerCategory;
    }

    public Boolean getTokenizeSupport() {
        return this.tokenizeSupport;
    }

    public void setTokenizeSupport(Boolean tokenizeSupport) {
        this.tokenizeSupport = tokenizeSupport;
    }

    public String getCardIssuerCountry() {
        return this.cardIssuerCountry;
    }

    public void setCardIssuerCountry(String cardIssuerCountry) {
        this.cardIssuerCountry = cardIssuerCountry;
    }

    public String getJuspayBankCode() {
        return this.juspayBankCode;
    }

    public void setJuspayBankCode(String juspayBankCode) {
        this.juspayBankCode = juspayBankCode;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }
}

