/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import in.juspay.exception.InvalidKeysException;
import in.juspay.exception.JuspayException;
import in.juspay.security.Keys;
import java.security.PrivateKey;
import java.security.PublicKey;

public class JweJwsEncryptionKeys {
    private PublicKey jwePublicKey;
    private PrivateKey jwsPrivateKey;
    private String keyId;

    public JweJwsEncryptionKeys(String keyId, String publicKey, String privateKey) throws JuspayException {
        this.withKeyId(keyId);
        this.withJwePublicKey(publicKey);
        this.withJwsPrivateKey(privateKey);
    }

    public void withKeyId(String val) {
        this.keyId = val;
    }

    public void withJwsPrivateKey(String key) throws JuspayException {
        try {
            this.jwsPrivateKey = Keys.readPrivateKey(key);
        }
        catch (Exception e) {
            throw new InvalidKeysException(-1, "invalid_private_key", "invalid_private_key", "Please check your private key");
        }
    }

    public void withJwePublicKey(String key) throws JuspayException {
        try {
            this.jwePublicKey = Keys.readPublicKey(key);
        }
        catch (Exception e) {
            throw new InvalidKeysException(-1, "invalid_public_key", "invalid_public_key", "Please check your public key");
        }
    }

    public PrivateKey getJwsPrivateKey() {
        return this.jwsPrivateKey;
    }

    public PublicKey getJwePublicKey() {
        return this.jwePublicKey;
    }

    public String getKeyId() {
        return this.keyId;
    }
}

