/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import in.juspay.model.WalletList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wallet
extends JuspayEntity {
    private String id;
    private String object;
    private String wallet;
    private String token;
    private Boolean linked;
    private Double currentBalance;
    private Date lastRefreshed;
    private String gatewayReferenceId;
    private JsonElement metadata;

    public static WalletList list(String customerId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.list(customerId, null);
    }

    public static WalletList list(String customerId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (customerId == null || customerId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = Wallet.makeServiceCall("/customers/" + customerId + "/wallets", null, JuspayEntity.RequestMethod.GET, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, WalletList.class);
    }

    public static WalletList refresh(String customerId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.refresh(customerId, null);
    }

    public static WalletList refresh(String customerId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (customerId == null || customerId.equals("")) {
            throw new InvalidRequestException();
        }
        JsonObject response = Wallet.makeServiceCall("/customers/" + customerId + "/wallets/refresh-balances", null, JuspayEntity.RequestMethod.GET, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, WalletList.class);
    }

    public static Wallet refreshByWalletId(String walletId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.refreshByWalletId(walletId, null);
    }

    public static Wallet refreshByWalletId(String walletId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (walletId == null || walletId.equals("")) {
            throw new InvalidRequestException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "refresh");
        JsonObject response = Wallet.makeServiceCall("/wallets/" + walletId, params, JuspayEntity.RequestMethod.GET, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, Wallet.class);
    }

    public static Wallet create(String customerId, String gateway) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createWallet(customerId, gateway, null, null);
    }

    public static Wallet create(String customerId, String gateway, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createWallet(customerId, gateway, null, requestOptions);
    }

    public static Wallet create(String customerId, String gateway, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createWallet(customerId, gateway, params, requestOptions);
    }

    private static Wallet createWallet(String customerId, String gateway, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (customerId == null || customerId.equals("") || gateway == null || gateway.equals("")) {
            throw new InvalidRequestException();
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("gateway", gateway);
        JsonObject response = Wallet.makeServiceCall("/customers/" + customerId + "/wallets", params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, Wallet.class);
    }

    public static Wallet createAndAuthenticate(String customerId, String gateway) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createAndAuthenticateWallet(customerId, gateway, null, null);
    }

    public static Wallet createAndAuthenticate(String customerId, String gateway, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createAndAuthenticateWallet(customerId, gateway, null, requestOptions);
    }

    public static Wallet createAndAuthenticate(String customerId, String gateway, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.createAndAuthenticateWallet(customerId, gateway, params, requestOptions);
    }

    private static Wallet createAndAuthenticateWallet(String customerId, String gateway, Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("command", "authenticate");
        return Wallet.createWallet(customerId, gateway, params, requestOptions);
    }

    public static Wallet authenticate(String walletId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.authenticate(walletId, null);
    }

    public static Wallet authenticate(String walletId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (walletId == null || walletId.equals("")) {
            throw new InvalidRequestException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "authenticate");
        JsonObject response = Wallet.makeServiceCall("/wallets/" + walletId, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, Wallet.class);
    }

    public static Wallet link(String walletId, String otp) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.link(walletId, otp, null);
    }

    public static Wallet link(String walletId, String otp, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (walletId == null || walletId.equals("") || otp == null || otp.equals("")) {
            throw new InvalidRequestException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("otp", otp);
        params.put("command", "link");
        JsonObject response = Wallet.makeServiceCall("/wallets/" + walletId, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, Wallet.class);
    }

    public static Wallet delink(String walletId) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Wallet.delink(walletId, null);
    }

    public static Wallet delink(String walletId, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (walletId == null || walletId.equals("")) {
            throw new InvalidRequestException();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "delink");
        JsonObject response = Wallet.makeServiceCall("/wallets/" + walletId, params, JuspayEntity.RequestMethod.POST, requestOptions);
        return Wallet.createEntityFromResponse((JsonElement)response, Wallet.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getWallet() {
        return this.wallet;
    }

    public void setWallet(String wallet) {
        this.wallet = wallet;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Double getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(Double currentBalance) {
        this.currentBalance = currentBalance;
    }

    public Date getLastRefreshed() {
        return this.lastRefreshed;
    }

    public void setLastRefreshed(Date lastRefreshed) {
        this.lastRefreshed = lastRefreshed;
    }

    public Boolean getLinked() {
        return this.linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }

    public String getGatewayReferenceId() {
        return this.gatewayReferenceId;
    }

    public void setGatewayReferenceId(String gatewayReferenceId) {
        this.gatewayReferenceId = gatewayReferenceId;
    }

    public JsonElement getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JsonElement metadata) {
        this.metadata = metadata;
    }
}

