/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.security;

import in.juspay.security.JuspayCryptoException;
import in.juspay.security.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWS {
    public static final String alg = "RS256";

    public static String sign(String claims, String keyId, PrivateKey privateKey) throws JuspayCryptoException {
        byte[] signatureBytes;
        Signature signatureSPI;
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new JuspayCryptoException("private key algorithm is not RSA");
        }
        if (claims == null || keyId == null) {
            throw new JuspayCryptoException("claims and keyId cannot be null");
        }
        String signatureHeader = "{\"alg\":\"RS256\",\"kid\":\"" + keyId + "\"}";
        String header = Utils.base64UrlEncodeAsString(signatureHeader);
        String payload = Utils.base64UrlEncodeAsString(claims);
        String data = header + "." + payload;
        try {
            signatureSPI = Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JuspayCryptoException("No such algorithm found:- " + e.getMessage(), e);
        }
        try {
            signatureSPI.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new JuspayCryptoException("Invalid private key:- " + e.getMessage(), e);
        }
        try {
            signatureSPI.update(data.getBytes());
            signatureBytes = signatureSPI.sign();
        }
        catch (SignatureException e) {
            throw new JuspayCryptoException("Signature Exception:- " + e.getMessage(), e);
        }
        String jwsSignature = Utils.base64UrlEncodeAsString(signatureBytes);
        return header + "." + payload + "." + jwsSignature;
    }

    public static String verify(Map<String, String> signedPayload, PublicKey publicKey) throws JuspayCryptoException {
        Signature signatureSPI;
        String header = signedPayload.get("header");
        String signature = signedPayload.get("signature");
        String payload = signedPayload.get("payload");
        String dataToVerify = header + "." + payload;
        try {
            signatureSPI = Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JuspayCryptoException("No such algorithm found:- " + e.getMessage(), e);
        }
        try {
            signatureSPI.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new JuspayCryptoException("Invalid private key:- " + e.getMessage(), e);
        }
        try {
            signatureSPI.update(dataToVerify.getBytes());
            signatureSPI.verify(Utils.base64UrlDecode(signature));
        }
        catch (SignatureException e) {
            throw new JuspayCryptoException("Signature Exception:- " + e.getMessage(), e);
        }
        return Utils.base64UrlDecodeAsString(payload);
    }

    public static String verify(String signedPayload, PublicKey publicKey) throws JuspayCryptoException {
        String[] encryptedPayloadParts = signedPayload.split("\\.");
        LinkedHashMap<String, String> reqASMap = new LinkedHashMap<String, String>();
        if (encryptedPayloadParts.length != 3) {
            throw new JuspayCryptoException("Request payload malformed");
        }
        reqASMap.put("header", encryptedPayloadParts[0]);
        reqASMap.put("payload", encryptedPayloadParts[1]);
        reqASMap.put("signature", encryptedPayloadParts[2]);
        return JWS.verify(reqASMap, publicKey);
    }
}

