package in.juspay.model;

import in.juspay.exception.InvalidKeysException;
import in.juspay.exception.JuspayException;
import in.juspay.security.Keys;

import java.security.*;

public class JweJwsEncryptionKeys {
    private PublicKey jwePublicKey;
    private PrivateKey jwsPrivateKey;
    private String keyId;

    public JweJwsEncryptionKeys(String keyId, String publicKey, String privateKey) throws JuspayException {
        this.withKeyId(keyId);
        this.withJwePublicKey(publicKey);
        this.withJwsPrivateKey(privateKey);
    }

    public void withKeyId(String val) {
        keyId = val;
    }

    public void withJwsPrivateKey(String key) throws JuspayException {
        try {
            jwsPrivateKey = Keys.readPrivateKey(key);
        } catch (Exception e) {
            throw new InvalidKeysException(-1, "invalid_private_key", "invalid_private_key", "Please check your private key");
        }
    }


    public void withJwePublicKey(String key) throws JuspayException {
        try {
            jwePublicKey = Keys.readPublicKey(key);
        } catch (Exception e) {
            throw new InvalidKeysException(-1, "invalid_public_key", "invalid_public_key", "Please check your public key");
        }
    }

    public PrivateKey getJwsPrivateKey() {
        return jwsPrivateKey;
    }

    public PublicKey getJwePublicKey() {
        return jwePublicKey;
    }

    public String getKeyId() {
        return keyId;
    }
}
