package in.juspay.security;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Utils {
    public static byte[] concatBytes(byte[]... arr) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (byte[] bytes : arr) {
                if (bytes != null) {
                    baos.write(bytes);
                }
            }
            return baos.toByteArray();
        } catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static byte[] subArray(byte[] byteArray, int beginIndex, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(byteArray, beginIndex, subArray, 0, subArray.length);
        return subArray;
    }

    public static int safeBitLength(byte[] bytes) throws JuspayCryptoException {
        if (bytes == null) {
            return 0;
        }
        int byteLength = bytes.length;
        long longResult = (long)byteLength * 8L;
        if ((long)((int)longResult) != longResult) {
            throw new JuspayCryptoException();
        } else {
            return (int)longResult;
        }
    }

    public static byte[] base64UrlEncode(byte[] bytes) {
        return Base64.encodeBase64URLSafe(bytes);
    }

    public static String base64UrlEncodeAsString(byte[] bytes) {
        return Base64.encodeBase64URLSafeString(bytes);
    }

    public static byte[] base64UrlDecode(String b64encoded) {
        return Base64.decodeBase64(b64encoded);
    }

    public static byte[] base64UrlEncode(String str) {
        return base64UrlEncode(StringUtils.getBytesUtf8(str));
    }

    public static String base64UrlEncodeAsString(String str) {
        return base64UrlEncodeAsString(StringUtils.getBytesUtf8(str));
    }

    public static String base64UrlDecodeAsString(String b64encoded) {
        return StringUtils.newStringUtf8(base64UrlDecode(b64encoded));
    }
}
