/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.security;

import in.juspay.security.JuspayCryptoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Keys {
    public static PublicKey readPublicKey(String key) throws JuspayCryptoException {
        String RSAPUBK_BEGIN = "-----BEGIN RSA PUBLIC KEY-----";
        String RSAPUBK_END = "-----END RSA PUBLIC KEY-----";
        String PUBK_BEGIN = "-----BEGIN PUBLIC KEY-----";
        String PUBK_END = "-----END PUBLIC KEY-----";
        String REPLACEMENT = "";
        String keyContent = key.replaceAll("\\n", "").replace("-----BEGIN RSA PUBLIC KEY-----", "").replace("-----END RSA PUBLIC KEY-----", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\r\n", "");
        byte[] keyBytes = Base64.decodeBase64((String)keyContent);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (Exception e) {
            throw new JuspayCryptoException("please check public key");
        }
    }

    public static PrivateKey readPrivateKey(String key) throws JuspayCryptoException {
        KeyFactory factory;
        String PKCS1_BEGIN = "-----BEGIN RSA PRIVATE KEY-----";
        String PKCS1_END = "-----END RSA PRIVATE KEY-----";
        String PKCS8_BEGIN = "-----BEGIN PRIVATE KEY-----";
        String PKCS8_END = "-----END PRIVATE KEY-----";
        String REPLACEMENT = "";
        String keyContent = key.replaceAll("\\n", "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("\r\n", "");
        byte[] keyBytes = Base64.decodeBase64((String)keyContent);
        try {
            factory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new JuspayCryptoException("No such algorithm found:- " + e.getMessage(), e);
        }
        if (key.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            RSAPrivateCrtKeySpec keySpec = Keys.getRSAPrivateKeySpec(keyBytes);
            try {
                return factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new JuspayCryptoException("please check pkcs1 key: " + e.getMessage());
            }
        }
        if (key.contains("-----BEGIN PRIVATE KEY-----")) {
            try {
                PKCS8EncodedKeySpec keySpecPv = new PKCS8EncodedKeySpec(keyBytes);
                return factory.generatePrivate(keySpecPv);
            }
            catch (InvalidKeySpecException e) {
                throw new JuspayCryptoException("please check pkcs8 key:- " + e.getMessage(), e);
            }
        }
        throw new JuspayCryptoException("key format not supported");
    }

    protected static RSAPrivateCrtKeySpec getRSAPrivateKeySpec(byte[] keyBytes) throws JuspayCryptoException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(keyBytes);
            Keys.initiateSequence(in);
            BigInteger ignoredVersion = Keys.readDERAsInteger(in);
            BigInteger modulus = Keys.readDERAsInteger(in);
            BigInteger publicExp = Keys.readDERAsInteger(in);
            BigInteger privateExp = Keys.readDERAsInteger(in);
            BigInteger prime1 = Keys.readDERAsInteger(in);
            BigInteger prime2 = Keys.readDERAsInteger(in);
            BigInteger exp1 = Keys.readDERAsInteger(in);
            BigInteger exp2 = Keys.readDERAsInteger(in);
            BigInteger certificateCoefficient = Keys.readDERAsInteger(in);
            if (in.read() != -1) {
                throw new JuspayCryptoException("private key too long, if not please check for spaces unwanted chars etc");
            }
            return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, certificateCoefficient);
        }
        catch (IOException e) {
            throw new JuspayCryptoException(e.getMessage(), e);
        }
    }

    private static BigInteger readDERAsInteger(ByteArrayInputStream in) throws JuspayCryptoException, IOException {
        int INTEGER = 2;
        int tag = Keys.getTag(in);
        int length = Keys.getLength(in);
        byte[] value = new byte[length];
        int n = in.read(value);
        if (n < length) {
            throw new JuspayCryptoException("key is too short");
        }
        if (Keys.getType(tag) != 2) {
            throw new JuspayCryptoException("parsed value is not integer");
        }
        return new BigInteger(value);
    }

    private static void initiateSequence(ByteArrayInputStream in) throws JuspayCryptoException, IOException {
        int DEM_SEQUENCE = 16;
        int PRIMITIVE_SEQUENCE = 32;
        int tag = Keys.getTag(in);
        int length = Keys.getLength(in);
        if (in.available() < length) {
            throw new JuspayCryptoException("key is too short");
        }
        if (Keys.getType(tag) != 16) {
            throw new JuspayCryptoException("cannot initiate key sequence, key is invalid");
        }
        if ((tag & 0x20) != 32) {
            throw new JuspayCryptoException("key is invalid");
        }
    }

    private static int getTag(ByteArrayInputStream in) throws JuspayCryptoException {
        int tag = in.read();
        if (tag == -1) {
            throw new JuspayCryptoException("key is too short");
        }
        return tag;
    }

    private static int getType(int tag) {
        return tag & 0x1F;
    }

    private static int getLength(ByteArrayInputStream in) throws JuspayCryptoException, IOException {
        int SHORT_BYTE_LENGTH = -128;
        int suffix = in.read();
        if (suffix == -1) {
            throw new JuspayCryptoException("key is too short, cannot get length");
        }
        if ((suffix & 0xFFFFFF80) == 0) {
            return suffix;
        }
        int size = suffix & 0x7F;
        if (suffix >= 255 || size > 4) {
            throw new JuspayCryptoException("der parsing not supported, please check your private key");
        }
        byte[] bytes = new byte[size];
        int n = in.read(bytes);
        if (n < size) {
            throw new JuspayCryptoException("key is too short");
        }
        return new BigInteger(1, bytes).intValue();
    }
}

