/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payment
extends JuspayEntity {
    String orderId;
    String txnId;
    String status;
    String method;
    String url;
    Map<String, String> params;
    Map<String, String> sdkParams;

    public static Payment create(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return Payment.create(params, null);
    }

    public static Payment create(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        params.put("format", "json");
        JsonObject response = Payment.makeServiceCall("/txns", params, JuspayEntity.RequestMethod.POST, requestOptions);
        response = Payment.updatePaymentResponseStructure(response);
        return Payment.createEntityFromResponse((JsonElement)response, Payment.class);
    }

    private static JsonObject updatePaymentResponseStructure(JsonObject response) {
        JsonObject authResp = response.get("payment").getAsJsonObject().get("authentication").getAsJsonObject();
        JsonElement sdk_params = response.get("payment").getAsJsonObject().get("sdk_params");
        response.add("method", authResp.get("method"));
        response.add("url", authResp.get("url"));
        if (response.get("method").getAsString().equals("POST")) {
            response.add("params", (JsonElement)new JsonObject());
            for (Map.Entry entry : authResp.get("params").getAsJsonObject().entrySet()) {
                response.get("params").getAsJsonObject().add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (sdk_params != null) {
            response.add("sdk_params", (JsonElement)new JsonObject());
            for (Map.Entry entry : sdk_params.getAsJsonObject().entrySet()) {
                response.get("sdk_params").getAsJsonObject().add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        response.remove("payment");
        return response;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public void setTxnId(String txnId) {
        this.txnId = txnId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getSdkParams() {
        return this.sdkParams;
    }

    public void setSdkParams(Map<String, String> sdkParams) {
        this.sdkParams = sdkParams;
    }
}

