/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.juspay.exception.APIConnectionException;
import in.juspay.exception.APIException;
import in.juspay.exception.AuthenticationException;
import in.juspay.exception.AuthorizationException;
import in.juspay.exception.InvalidRequestException;
import in.juspay.model.JuspayEntity;
import in.juspay.model.RequestOptions;
import in.juspay.model.SessionApiPaymentLinks;
import java.util.Map;

public class OrderSession
extends JuspayEntity {
    private SessionApiPaymentLinks paymentLinks;
    private String orderId;
    private String status;
    private Map<String, Object> sdkPayload;
    private String id;
    private String expiry;

    public static OrderSession create(Map<String, Object> params) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        return OrderSession.create(params, null);
    }

    public static OrderSession create(Map<String, Object> params, RequestOptions requestOptions) throws APIException, APIConnectionException, AuthorizationException, AuthenticationException, InvalidRequestException {
        if (params == null || params.size() == 0) {
            throw new InvalidRequestException();
        }
        if (requestOptions == null) {
            requestOptions = RequestOptions.createDefault();
        }
        requestOptions.withHeaders("Content-Type", "application/json");
        String path = OrderSession.getEncryptionMethodBasedOnConfig(requestOptions) == JuspayEntity.AuthMethod.JWE_JWS ? "/v4/session" : "/session";
        JsonObject response = OrderSession.makeServiceCallWithAuthDecider(path, params, JuspayEntity.RequestMethod.POST, requestOptions);
        response = OrderSession.addInputParamsToResponse(params, response);
        return OrderSession.createEntityFromResponse((JsonElement)response, OrderSession.class);
    }

    public SessionApiPaymentLinks getPaymentLinks() {
        return this.paymentLinks;
    }

    public void setPaymentLinks(SessionApiPaymentLinks paymentLinks) {
        this.paymentLinks = paymentLinks;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, Object> getSdkPayload() {
        return this.sdkPayload;
    }

    public void setSdkPayload(Map<String, Object> sdkPayload) {
        this.sdkPayload = sdkPayload;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }
}

