/*
 * Decompiled with CFR 0.152.
 */
package in.juspay.security;

import in.juspay.security.JuspayCryptoException;
import in.juspay.security.Utils;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.StringUtils;

public class JWE {
    public static final String alg = "RSA-OAEP-256";

    public static String encrypt(String payload, String keyId, PublicKey publicKey) throws JuspayCryptoException {
        GCMParameterSpec actualParams;
        byte[] cipherOutput;
        Cipher cipher;
        String encryptedKey;
        SecureRandom secureRandom = new SecureRandom();
        String headers = "{\"alg\":\"RSA-OAEP-256\",\"enc\":\"A256GCM\",\"kid\":\"" + keyId + "\",\"cty\":\"JWT\"}";
        String jweHeader = new String(Utils.base64UrlEncode(headers));
        byte[] cekMt = new byte[32];
        secureRandom.nextBytes(cekMt);
        SecretKeySpec cek = new SecretKeySpec(cekMt, "AES");
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(paramSpec);
            Cipher cipherEK = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
            cipherEK.init(1, (Key)publicKey, algorithmParameters);
            byte[] cekB = cipherEK.doFinal(cek.getEncoded());
            encryptedKey = Utils.base64UrlEncodeAsString(cekB);
        }
        catch (IllegalBlockSizeException e) {
            throw new JuspayCryptoException("rsa key block size exception", e);
        }
        catch (Exception e) {
            throw new JuspayCryptoException(e.getMessage(), e);
        }
        byte[] iv = new byte[12];
        secureRandom.nextBytes(iv);
        byte[] clearText = payload.getBytes();
        byte[] aad = Utils.base64UrlEncode(headers.getBytes());
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)cek, gcmSpec);
        }
        catch (Exception e) {
            throw new JuspayCryptoException(e);
        }
        cipher.updateAAD(aad);
        try {
            cipherOutput = cipher.doFinal(clearText);
        }
        catch (IllegalBlockSizeException e) {
            throw new JuspayCryptoException(e);
        }
        catch (BadPaddingException e) {
            throw new JuspayCryptoException(e);
        }
        int tagPos = cipherOutput.length - 16;
        byte[] cipherText = Utils.subArray(cipherOutput, 0, tagPos);
        byte[] authTag = Utils.subArray(cipherOutput, tagPos, 16);
        try {
            actualParams = cipher.getParameters().getParameterSpec(GCMParameterSpec.class);
        }
        catch (InvalidParameterSpecException ignoredException) {
            throw new JuspayCryptoException(ignoredException.getMessage(), ignoredException);
        }
        byte[] updatedIV = actualParams.getIV();
        int tLen = actualParams.getTLen();
        if (Utils.safeBitLength(updatedIV) != 96 && tLen != 128) {
            throw new JuspayCryptoException("Actual len differ iv, " + Utils.safeBitLength(iv) + " tLen " + tLen);
        }
        return jweHeader + "." + encryptedKey + "." + Utils.base64UrlEncodeAsString(updatedIV) + "." + Utils.base64UrlEncodeAsString(cipherText) + "." + Utils.base64UrlEncodeAsString(authTag);
    }

    public static String decrypt(Map<String, String> data, PrivateKey privateKey) throws JuspayCryptoException {
        byte[] plainText;
        Cipher cipher;
        SecretKeySpec cek;
        String header = data.get("header");
        String encryptedKey = data.get("encryptedKey");
        String iv = data.get("iv");
        String encryptedPayload = data.get("encryptedPayload");
        String tag = data.get("tag");
        String jcaAlgName = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
        String jcaShaAlgName = "SHA-256";
        MGF1ParameterSpec mgf1ParameterSpec = MGF1ParameterSpec.SHA256;
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
            OAEPParameterSpec paramSpec = new OAEPParameterSpec(jcaShaAlgName, "MGF1", mgf1ParameterSpec, PSource.PSpecified.DEFAULT);
            algorithmParameters.init(paramSpec);
            Cipher cipherForKey = Cipher.getInstance(jcaAlgName);
            cipherForKey.init(2, (Key)privateKey, algorithmParameters);
            cek = new SecretKeySpec(cipherForKey.doFinal(Utils.base64UrlDecode(encryptedKey)), "AES");
        }
        catch (Exception e) {
            throw new JuspayCryptoException(e);
        }
        byte[] aad = header.getBytes();
        try {
            cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, Utils.base64UrlDecode(iv));
            cipher.init(2, (Key)cek, gcmSpec);
        }
        catch (Exception e) {
            throw new JuspayCryptoException("Cannot make AES/GCM/NoPadding cipher:- " + e.getMessage(), e);
        }
        cipher.updateAAD(aad);
        try {
            plainText = cipher.doFinal(Utils.concatBytes(Utils.base64UrlDecode(encryptedPayload), Utils.base64UrlDecode(tag)));
        }
        catch (Exception e) {
            throw new JuspayCryptoException("decryption failed:- " + e.getMessage(), e);
        }
        return StringUtils.newStringUtf8((byte[])plainText);
    }

    public static String decrypt(String payload, PrivateKey privateKey) throws JuspayCryptoException {
        String[] encryptedPayloadParts = payload.split("\\.");
        LinkedHashMap<String, String> reqASMap = new LinkedHashMap<String, String>();
        if (encryptedPayloadParts.length != 5) {
            throw new JuspayCryptoException("Request payload malformed");
        }
        reqASMap.put("header", encryptedPayloadParts[0]);
        reqASMap.put("encryptedKey", encryptedPayloadParts[1]);
        reqASMap.put("iv", encryptedPayloadParts[2]);
        reqASMap.put("encryptedPayload", encryptedPayloadParts[3]);
        reqASMap.put("tag", encryptedPayloadParts[4]);
        return JWE.decrypt(reqASMap, privateKey);
    }
}

