/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.classifierYuga;

import com.twelfthmile.yuga.Yuga;
import com.twelfthmile.yuga.classifierYuga.StateMachines;
import com.twelfthmile.yuga.types.IndexTrack;
import com.twelfthmile.yuga.types.Pair;
import com.twelfthmile.yuga.types.Response;
import com.twelfthmile.yuga.types.Trie;
import com.twelfthmile.yuga.types.TrieNode;
import com.twelfthmile.yuga.types.Triplet;
import com.twelfthmile.yuga.utils.Constants;
import com.twelfthmile.yuga.utils.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ClassifierYuga {
    private static Trie prefixTrie = new Trie();
    private static Trie upiTrie = new Trie();

    public static JSONObject getYugaTokensNew(String sentence, HashMap<String, String> configMap, IndexTrack indexTrack) throws JSONException {
        Pair<Integer, String> prevToken = new Pair<Integer, String>(0, "");
        Set<String> unmaskTokenSet = Constants.unmaskTokenSet;
        HashMap<String, Integer> tokenCount = new HashMap<String, Integer>();
        int start = 0;
        for (String key : unmaskTokenSet) {
            tokenCount.put(key, 0);
        }
        StringBuilder sb = new StringBuilder("");
        HashMap<String, JSONObject> metaData = new HashMap<String, JSONObject>();
        while (indexTrack.next < sentence.length()) {
            Boolean flag = false;
            if (ClassifierYuga.skipCharacter(sentence, indexTrack.next, sentence.charAt(indexTrack.next))) {
                ++indexTrack.next;
                continue;
            }
            char ch = sentence.charAt(indexTrack.next);
            Pair<Integer, Pair> res = ClassifierYuga.getTokenEndIndex(sentence, indexTrack.next, prefixTrie);
            int tokenEndIndex = res.getA();
            start = indexTrack.next;
            Pair<String, Integer> p = ClassifierYuga.classifyTokens(sentence.substring(indexTrack.next), sentence.substring(indexTrack.next, tokenEndIndex).toLowerCase(), indexTrack, configMap, prevToken, res.getB());
            if (Constants.possiblePrevTokens.containsKey(sentence.substring(start, tokenEndIndex).toLowerCase())) {
                prevToken.setB(Constants.possiblePrevTokens.get(sentence.substring(start, tokenEndIndex).toLowerCase()));
                flag = true;
                prevToken.setA(1);
            }
            if (p != null) {
                sb.append(sentence.substring(start, p.getB()));
                prevToken = new Pair<Integer, String>(0, "");
                sb.append(p.getA());
                if (tokenCount.containsKey(p.getA())) {
                    JSONObject metValForToken = new JSONObject();
                    metValForToken.put("INDEX", (Object)String.valueOf(p.getB()));
                    if ((Integer)tokenCount.get(p.getA()) == 0) {
                        metaData.put(p.getA(), metValForToken);
                    } else {
                        metaData.put(p.getA() + "_" + tokenCount.get(p.getA()), metValForToken);
                    }
                    tokenCount.put(p.getA(), (Integer)tokenCount.get(p.getA()) + 1);
                }
                sb.append(" ");
            } else {
                sb.append(sentence.substring(indexTrack.next, tokenEndIndex));
                sb.append(" ");
                indexTrack.next = tokenEndIndex + 1;
                if (prevToken != null && !flag.booleanValue()) {
                    prevToken.setA(prevToken.getA() + 1);
                }
            }
            sb.append("");
        }
        return ClassifierYuga.generateOutput(sb, metaData);
    }

    public static JSONObject generateOutput(StringBuilder sb, Map<String, JSONObject> metaData) throws JSONException {
        JSONObject jsonData = new JSONObject();
        jsonData.put("message", (Object)sb.toString().trim());
        jsonData.put("METADATA", (Object)new JSONObject(metaData));
        return jsonData;
    }

    public static boolean skipCharacter(String sentence, int index, char ch) {
        return ClassifierYuga.goodEndings(sentence.charAt(index)) || ch == '+' || ch == '\\';
    }

    private static Pair<Integer, Pair> getTokenEndIndex(String sentence, int index, Trie prefixTrie) {
        String subSentence = sentence.substring(index);
        Pair<Integer, Pair> nextSpaceIndex = ClassifierYuga.nextDelimeterImmediate(subSentence, prefixTrie);
        int idx = nextSpaceIndex.getA() + index;
        nextSpaceIndex.setA(idx);
        return nextSpaceIndex;
    }

    private static Pair<Integer, Pair> nextDelimeterImmediate(String str, Trie prefixTrie) {
        int i;
        int len = 0;
        String label = null;
        TrieNode root = prefixTrie.root;
        String sentence = str.toLowerCase();
        for (i = 0; i < sentence.length(); ++i) {
            char ch = sentence.charAt(i);
            if (root.hasNext(ch)) {
                root = root.get(ch);
                ++len;
                if (root.isEnd()) {
                    label = root.getLabel();
                }
            }
            if (!ClassifierYuga.goodEndings(sentence.charAt(i))) continue;
            if (label != null) {
                Pair<Integer, String> p = new Pair<Integer, String>(len, label);
                return new Pair<Integer, Pair>(i, p);
            }
            return new Pair<Integer, Object>(i, null);
        }
        return new Pair<Integer, Object>(i, null);
    }

    static boolean goodEndings(char ch) {
        return ch == ' ' || ch == ',' || ch == ':' || ch == '.' || ch == ')' || ch == '-' || ch == '(' || ch == '\"' || ch == '=' || ch == '<' || ch == '>' || ch == '\r' || ch == '\n' || ch == '!';
    }

    static Pair<String, Integer> classifyTokens(String sentence, String word, IndexTrack indexTrack, HashMap<String, String> configMap, Pair<Integer, String> prevToken, Pair<Integer, String> prefix) {
        if (prefix != null && prefix.getB().equals("CRNCY")) {
            Pair<Integer, Boolean> p = ClassifierYuga.lookAheadIntegerForAmt(sentence.substring(prefix.getA()));
            if (p.getA() >= 0 && p.getB().booleanValue()) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(p.getA() + prefix.getA(), indexTrack);
                return new Pair<String, Integer>("AMT", start);
            }
        } else if (Constants.tokens.containsKey(word) && Constants.tokens.get(word).equals("TRANSFER")) {
            String refId = null;
            String userId = null;
            HashMap<String, String> userMap = new HashMap<String, String>();
            StateMachines.checkForUPI(word, refId, userId, userMap, 0);
            if (refId != null) {
                int start = indexTrack.next;
                switch (word) {
                    case "upi": {
                        return new Pair<String, Integer>("UPI", start);
                    }
                    case "mmt": {
                        return new Pair<String, Integer>("IMPS", start);
                    }
                    case "neft": {
                        return new Pair<String, Integer>("NEFT", start);
                    }
                }
            }
        } else if (prefix != null && prefix.getB().equals("FLTID")) {
            Triplet<Integer, String, String> t;
            int i = ClassifierYuga.lookAheadInteger(sentence.substring(word.length()));
            boolean nextIsNumber = i + 1 + word.length() < sentence.length() && Util.isNumber(sentence.charAt(i + 1 + word.length()));
            Boolean currencyPosible = false;
            if (i >= 0 && i <= 5 && nextIsNumber && (t = StateMachines.numberParse(sentence.substring(i + word.length()))) != null) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(word.length() + i + t.getA(), indexTrack);
                return new Pair<String, Integer>("FLTIDVAL", start);
            }
        } else if (Constants.tokens.containsKey(word) && Constants.tokens.get(word).equals("HTTP")) {
            Pair<Integer, String> p = StateMachines.linkParse(sentence + " ", word.length());
            if (p != null) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(p.getA(), indexTrack);
                return new Pair<String, Integer>("URL", start);
            }
        } else if (Constants.tokens.containsKey(word) && Constants.tokens.get(word).equals("SMS")) {
            int i = indexTrack.next + 1;
            StringBuilder smsCode = new StringBuilder("");
            Boolean legit = false;
            StateMachines.smsCode(word, indexTrack.next, i, smsCode, legit);
            if (legit.booleanValue()) {
                int start = indexTrack.next;
                return new Pair<String, Integer>("SMSCODE", start);
            }
        } else if (Constants.tokens.containsKey(word) && Constants.tokens.get(word).equals("WWW")) {
            Integer val = StateMachines.wwwParse(sentence + " ", word.length());
            if (val != null) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(val, indexTrack);
                return new Pair<String, Integer>("URL", start);
            }
        } else if (Constants.tokens.containsKey(word) && Constants.tokens.get(word).equals("IDPRX")) {
            Triplet<Integer, String, String> t;
            int i = ClassifierYuga.lookAheadNumberForIdPrx(sentence.substring(indexTrack.next));
            StringBuilder num = new StringBuilder();
            boolean idx = false;
            boolean currencyPossible = false;
            if (i >= 0 && i <= 2 && (t = StateMachines.numberParse(sentence.substring(i + indexTrack.next))) != null) {
                int start = indexTrack.next;
                return new Pair<String, Integer>("NUM", start);
            }
        }
        return ClassifierYuga.classifyTokensUsingNext(sentence, word, indexTrack.next, configMap, indexTrack, prevToken, prefix);
    }

    static Pair<String, Integer> classifyTokensUsingNext(String sentence, String word, int index, HashMap<String, String> configMap, IndexTrack indexTrack, Pair<Integer, String> prevToken, Pair<Integer, String> prefix) {
        if (sentence.charAt(0) == '#') {
            int i = ClassifierYuga.lookAheadHash(sentence);
            ClassifierYuga.setNextindex(i, indexTrack);
            Response t = Yuga.parse(sentence.substring(i), configMap);
            if (t != null) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(t.getIndex(), indexTrack);
                return new Pair<String, Integer>(t.getType(), start);
            }
        }
        return ClassifierYuga.classifyInGeneral(sentence, configMap, indexTrack, prevToken, prefix);
    }

    static Pair<String, Integer> classifyInGeneral(String sentence, HashMap<String, String> configMap, IndexTrack indexTrack, Pair<Integer, String> prevToken, Pair<Integer, String> prefix) {
        Pair<Integer, String> p;
        String prevTok;
        Response t;
        if (prefix != null && prefix.getB().equals("INSTR")) {
            t = Yuga.parse(sentence.substring(prefix.getA()), configMap);
            if (t != null) {
                int start = indexTrack.next;
                ClassifierYuga.setNextindex(t.getIndex() + prefix.getA(), indexTrack);
                return new Pair<String, Integer>("INSTRNO", start + prefix.getA());
            }
        } else {
            t = Yuga.parse(sentence, configMap);
            if (t != null) {
                Integer idx;
                if (t.getType().equals("NUM") && (idx = ClassifierYuga.classifyUpiWrapper(sentence, t.getIndex())) != null) {
                    int start = indexTrack.next;
                    ClassifierYuga.setNextindex(idx + 1, indexTrack);
                    return new Pair<String, Integer>("UPI", start);
                }
                if (t.getType() != "STR") {
                    int start = indexTrack.next;
                    ClassifierYuga.setNextindex(t.getIndex(), indexTrack);
                    return new Pair<String, Integer>(t.getType(), start);
                }
            }
        }
        if (prevToken != null && (prevTok = prevToken.getB()).equals("INS") && prevToken.getA() <= 2 && (p = StateMachines.reCheckForAccount(sentence)) != null) {
            int start = indexTrack.next;
            ClassifierYuga.setNextindex(p.getA(), indexTrack);
            return new Pair<String, Integer>("INSTRNO", start);
        }
        Pair<Integer, String> p2 = StateMachines.checkForURL(sentence + " ");
        if (p2 != null) {
            int start = indexTrack.next;
            ClassifierYuga.setNextindex(p2.getA(), indexTrack);
            return new Pair<String, Integer>("URL", start);
        }
        Integer i = StateMachines.mailIdParse(sentence);
        if (i != null) {
            int start = indexTrack.next;
            ClassifierYuga.setNextindex(i, indexTrack);
            return new Pair<String, Integer>("EMAILADDRESS", start);
        }
        p2 = StateMachines.checkForId(sentence, 0);
        if (prevToken != null) {
            String prevTok2 = prevToken.getB();
            if (p2 != null && prevTok2.equals("ID") && prevToken.getA() <= 2) {
                int start = indexTrack.next;
                char ch = sentence.charAt(p2.getA());
                ClassifierYuga.setNextindex(p2.getA() + 1, indexTrack);
                return new Pair<String, Integer>("IDVAL", start);
            }
        }
        return null;
    }

    private static Integer classifyUpiWrapper(String sentence, int index) {
        int ind;
        if (index >= sentence.length()) {
            return null;
        }
        if (sentence.charAt(index) == '(') {
            ++index;
        }
        for (int i = index; i < sentence.length(); ++i) {
            if (sentence.charAt(i) == '@' || sentence.charAt(i) == '\u00a1') {
                index = i;
                break;
            }
            if (Util.isNumber(sentence.charAt(i)) || Util.isAlpha(sentence.charAt(i)) || sentence.charAt(i) == '.' || sentence.charAt(i) == '-') continue;
            return null;
        }
        if ((ind = ClassifierYuga.classifyUpi(sentence.substring(index + 1))) > 0) {
            return index + ind + 1;
        }
        return null;
    }

    private static int classifyUpi(String handle) {
        TrieNode t = ClassifierYuga.upiTrie.root;
        int x = -1;
        for (int i = 0; i < handle.length(); ++i) {
            char c = handle.charAt(i);
            if (t.hasNext(c)) {
                if (!(t = t.get(c)).isEnd() || i + 1 >= handle.length() || handle.charAt(i + 1) != '.' && handle.charAt(i + 1) != ' ' && handle.charAt(i + 1) != ')' && handle.charAt(i + 1) != '(' && (x = StateMachines.checkifsc(handle.substring(i + 1))) <= 0) continue;
                if (x > 0) {
                    return i + x;
                }
                return i;
            }
            int d = ClassifierYuga.lookAheadDotForUPI(handle.substring(i));
            if (d <= 0 || i + d + 10 >= handle.length() || !handle.substring(i + d + 1, i + d + 10).equals("ifsc.npci")) break;
            return i + d + 10;
        }
        return -1;
    }

    private static int lookAheadDotForUPI(String sentence) {
        for (int index = 0; index < sentence.length(); ++index) {
            char c = sentence.charAt(index);
            if (Util.isAlpha(c) || Util.isNumber(c)) continue;
            if (c == '.') {
                return index;
            }
            return -1;
        }
        return -1;
    }

    private static boolean isNextId(int nextInd, String sentence) {
        StringBuilder sb = new StringBuilder("");
        int i = nextInd;
        char ch = sentence.charAt(i);
        while (!ClassifierYuga.goodEndings(ch)) {
            sb.append(ch);
            ch = sentence.charAt(++i);
        }
        return sb.toString().equals("id");
    }

    private static int lookAheadInteger(String sentence) {
        int index;
        for (index = 0; index < sentence.length(); ++index) {
            char c = sentence.charAt(index);
            if (c == ' ' || c == '.' || c == ':' || c == '-' || c == ',') continue;
            if (Util.isNumber(c)) break;
            return -1;
        }
        return index;
    }

    private static Pair<Integer, Boolean> lookAheadIntegerForAmt(String sentence) {
        Boolean flag = false;
        for (int index = 0; index < sentence.length(); ++index) {
            char c = sentence.charAt(index);
            if (c == ' ' || c == ':' || c == '<' || c == '?' || c == '|') continue;
            if (c == '.' && index == sentence.length() - 1) {
                return new Pair<Integer, Boolean>(index, flag);
            }
            if (c == '.' || c == ',') {
                if (index <= 0 || sentence.charAt(index - 1) != ' ' || index + 1 >= sentence.length() || !Util.isNumber(sentence.charAt(index + 1))) continue;
                break;
            }
            if (Util.isNumber(c) && index + 1 < sentence.length() || c == '-' || c == '*') {
                flag = true;
                continue;
            }
            if (Util.isNumber(c) && index + 1 == sentence.length()) {
                flag = true;
                return new Pair<Integer, Boolean>(index + 1, flag);
            }
            return new Pair<Integer, Boolean>(index, flag);
        }
        return new Pair<Integer, Boolean>(-1, false);
    }

    public static int lookAheadNumberForIdPrx(String sentence) {
        char c;
        int i;
        for (i = 0; i < sentence.length() && ((c = sentence.charAt(i)) == ' ' || c == '-' || !Util.isNumber(c) && i <= 3); ++i) {
        }
        return i;
    }

    public static void setNextindex(int idx, IndexTrack indexTrack) {
        indexTrack.next += idx;
    }

    private static int lookAheadHash(String sentence) {
        char c;
        int index;
        for (index = 1; index < sentence.length() && (c = sentence.charAt(index)) == ' '; ++index) {
        }
        return index;
    }

    static {
        prefixTrie.loadTrie();
        upiTrie.insertUpis();
    }
}

