/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.classifierYuga;

import com.twelfthmile.yuga.Yuga;
import com.twelfthmile.yuga.types.Pair;
import com.twelfthmile.yuga.types.Triplet;
import com.twelfthmile.yuga.utils.Util;
import java.util.HashMap;

public class StateMachines {
    public static int checkifsc(String str) {
        int state = 1;
        block4: for (int i = 0; state > 0 && i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 1: {
                    if (Util.isNumber(ch)) {
                        state = 1;
                        continue block4;
                    }
                    if (ch == '.') {
                        state = 2;
                        continue block4;
                    }
                    state = -1;
                    continue block4;
                }
                case 2: {
                    if (i + 9 < str.length() && str.substring(i, i + 9).equals("ifsc.npci")) {
                        return i + 9;
                    }
                    state = -1;
                }
            }
        }
        return -1;
    }

    public static int cdrParse(String str) {
        int state = 1;
        int ret = -1;
        block5: for (int i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == 'C') {
                        ret = 1;
                        state = 2;
                        continue block5;
                    }
                    if (c == 'D') {
                        ret = 0;
                        state = 2;
                        continue block5;
                    }
                    state = -1;
                    continue block5;
                }
                case 2: {
                    if (c == 'R' || c == 'r') {
                        state = 3;
                        continue block5;
                    }
                    state = -1;
                    continue block5;
                }
                case 3: {
                    if (c == ' ' || c == '.' || c == ',' || c == ';') {
                        return ret;
                    }
                    return -1;
                }
            }
        }
        return -1;
    }

    public static Integer wwwParse(String str, int indRead) {
        int state = 1;
        int dotcounter = 0;
        block3: for (int i = indRead - 1; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == ' ') {
                        int x = i;
                        if (i > 0 && (str.charAt(i - 1) == '.' || str.charAt(i - 1) == ')')) {
                            x = i > 1 && str.charAt(i - 2) == ')' ? i - 2 : i - 1;
                        }
                        if (i != indRead && dotcounter > 1) {
                            return x;
                        }
                        return null;
                    }
                    if (c == '.') {
                        ++dotcounter;
                        if (i <= 3 || !str.substring(i - 3, i).equals("com") && !str.substring(i - 2, i).equals("in")) continue block3;
                        return i;
                    }
                    if (c == '/' || c == '=' || c == '?' || c == '<' || c == '>' || Util.isAlpha(c) || Util.isNumber(c) || c == '-') continue block3;
                    state = -1;
                }
            }
        }
        return null;
    }

    public static Pair<Integer, String> linkParse(String str, int indRead) {
        int state = 1;
        int i = indRead;
        block4: while (state > 0 && i < str.length()) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == ':' && i + 1 < str.length() && str.charAt(i + 1) == '/') {
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (c != ' ' && c != '\n' && (c != '\\' || i + 1 >= str.length() || str.charAt(i + 1) != 'n')) break;
                    int x = i;
                    if (i > 3 && i < str.length() && (str.substring(i - 3, i).equals("www") || str.substring(i - 3, i).equals("ww."))) {
                        Pair<Integer, String> p = StateMachines.checkForURL(str.substring(i + 1));
                        if (p != null) {
                            p.setA(i + 1 + p.getA());
                            return p;
                        }
                        return null;
                    }
                    if (c == ' ' && i + 5 < str.length() && (str.substring(i + 1, i + 4).equals("in/") || str.substring(i + 1, i + 5).equals("com/"))) {
                        ++i;
                        continue block4;
                    }
                    if (i > 0 && (str.charAt(i - 1) == '.' || str.charAt(i - 1) == ')')) {
                        x = i > 1 && str.charAt(i - 2) == ')' ? i - 2 : i - 1;
                    }
                    return new Pair<Integer, String>(x, str.substring(0, x));
                }
            }
            ++i;
        }
        return null;
    }

    public static Pair<Integer, String> checkForURL(String str) {
        int state = 1;
        int dotCounter = 0;
        int slashCounter = 0;
        block4: for (int i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == '.' && i + 1 < str.length() && !Util.isDelimiter(str.charAt(i + 1))) {
                        if (++dotCounter < 2 || i <= 5) continue block4;
                        state = 2;
                        continue block4;
                    }
                    if (c == '/' && i >= 5 && dotCounter > 0) {
                        ++slashCounter;
                        state = 2;
                        continue block4;
                    }
                    if (Util.isAlpha(c) || Util.isNumber(c)) continue block4;
                    state = -1;
                    continue block4;
                }
                case 2: {
                    if (c == '/') {
                        ++slashCounter;
                        continue block4;
                    }
                    if (c == '.') {
                        ++dotCounter;
                        continue block4;
                    }
                    if (c == ',') {
                        return null;
                    }
                    if (c != ' ') continue block4;
                    if (dotCounter >= 2 && slashCounter < 1) {
                        return null;
                    }
                    return new Pair<Integer, String>(i, str.substring(0, i));
                }
            }
        }
        return null;
    }

    public static void checkForUPI(String str, String refId, String userId, HashMap<String, String> userMap, int i) {
        int state = 1;
        StringBuilder sb = new StringBuilder("");
        int wordCount = -1;
        Yuga.init();
        String prefix = "";
        while (state > 0 && i < str.length()) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    Pair<Integer, String> p = Yuga.checkTypes("FSA_UPI", str.substring(i));
                    if (p != null) {
                        i += p.getA().intValue();
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    int j = StateMachines.lookAheadIntegerForUPI(str.substring(i));
                    if (j != -1 && j < 6) {
                        sb.append(str.charAt(i += j));
                        state = 3;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    if (Util.isNumber(c)) {
                        sb.append(c);
                        state = 3;
                        break;
                    }
                    if (StateMachines.isUPIDelimeter(c)) {
                        refId = sb.toString();
                        sb = new StringBuilder("");
                        state = 4;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 4: {
                    if (Util.isNumber(c) || Util.isUpperAlpha(c) || Util.isLowerAlpha(c)) {
                        if (wordCount == -1) {
                            wordCount = 0;
                        }
                        sb.append(c);
                        state = 4;
                        if (i + 1 != str.length()) break;
                        userId = sb.toString();
                        sb = new StringBuilder("");
                        break;
                    }
                    if (wordCount > -1 && wordCount < 2 && c == ' ') {
                        ++wordCount;
                        sb.append(c);
                        state = 4;
                        if (i + 1 != str.length()) break;
                        userId = sb.toString();
                        sb = new StringBuilder("");
                        break;
                    }
                    if (c == '@') {
                        if (!prefix.equals("")) {
                            userMap.put(prefix, sb.toString());
                        }
                        userId = sb.toString();
                        sb = new StringBuilder("");
                        state = 5;
                        break;
                    }
                    String u = sb.toString();
                    if ("from".equalsIgnoreCase(u)) {
                        prefix = "from";
                        sb = new StringBuilder("");
                        state = 4;
                        break;
                    }
                    userId = u;
                    sb = new StringBuilder("");
                    --i;
                    state = -1;
                    break;
                }
                case 5: {
                    if (Util.isUpperAlpha(c) || Util.isLowerAlpha(c) || c == '.' || StateMachines.isUPIDelimeter(c)) {
                        state = 5;
                        break;
                    }
                    if (Util.isNumber(c)) {
                        if (StateMachines.isUPIDelimeter(str.charAt(i - 1))) {
                            sb.append(c);
                            state = 6;
                            break;
                        }
                        state = 5;
                        break;
                    }
                    if (i >= 2 && "to".equalsIgnoreCase(str.substring(i - 2, i))) {
                        prefix = "to";
                        sb = new StringBuilder("");
                        state = 4;
                        break;
                    }
                    --i;
                    state = -1;
                    break;
                }
                case 6: {
                    if (Util.isNumber(c)) {
                        sb.append(c);
                        state = 6;
                        break;
                    }
                    if (sb.toString().length() > 6) {
                        refId = sb.toString();
                    }
                    sb = new StringBuilder("");
                    --i;
                    state = -1;
                }
            }
            ++i;
        }
    }

    public static Triplet<Integer, String, String> numberParse(String str) {
        int i;
        int state = 1;
        boolean currencyPossible = false;
        StringBuilder num = new StringBuilder();
        block5: for (i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (Util.isNumber(c) || c == '-') {
                        state = 2;
                        num.append(c);
                        continue block5;
                    }
                    state = -1;
                    continue block5;
                }
                case 2: {
                    if (Util.isNumber(c)) {
                        num.append(c);
                        continue block5;
                    }
                    if (c == ',') continue block5;
                    if (c == '.') {
                        num.append(c);
                        state = 3;
                        continue block5;
                    }
                    if (c == '\n') continue block5;
                    state = -1;
                    continue block5;
                }
                case 3: {
                    if (Util.isNumber(c)) {
                        currencyPossible = true;
                        num.append(c);
                        continue block5;
                    }
                    if (!currencyPossible && num.length() > 0) {
                        num.deleteCharAt(num.length() - 1);
                    }
                    state = -1;
                }
            }
        }
        if (i == str.length()) {
            ++i;
        }
        if (state == -1 && num.length() == 0) {
            return null;
        }
        if (currencyPossible) {
            return new Triplet<Integer, String, String>(i - 1, num.toString(), "AMT");
        }
        return new Triplet<Integer, String, String>(i - 1, num.toString(), "NUM");
    }

    public static void smsCode(String str, int indRead, int i, StringBuilder smsCode, boolean legit) {
        int state = 1;
        while (state > 0 && i < str.length()) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if ((c == ':' || c == '-') && i < indRead + 3) {
                        state = 1;
                        break;
                    }
                    if (Util.isUpperAlpha(c) || c == ' ') {
                        smsCode.append(c);
                        state = 1;
                        break;
                    }
                    if (c == '<' || c == '(') {
                        smsCode.append(c);
                        state = 2;
                        break;
                    }
                    if (i > indRead + 4) {
                        legit = true;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (Util.isAlpha(c) || c == ' ' || Util.isNumber(c)) {
                        smsCode.append(c);
                        state = 2;
                        break;
                    }
                    if (c == '>' || c == ')') {
                        smsCode.append(c);
                        state = 1;
                        break;
                    }
                    state = -1;
                }
            }
            ++i;
        }
    }

    public static Integer mailIdParse(String str) {
        int state = 1;
        int countBefAtrt = 0;
        int labelCounter = 0;
        int atrtIdx = 0;
        int dotCountAfterAtrt = 0;
        block4: for (int i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (c == '@' && i - countBefAtrt > 1) {
                        state = 2;
                        atrtIdx = i;
                        continue block4;
                    }
                    if (c == '.') {
                        if ((i - 1 <= 0 || str.charAt(i - 1) != '.') && (i + 1 >= str.length() || str.charAt(i + 1) != '@')) continue block4;
                        state = -1;
                        continue block4;
                    }
                    if (c != ' ') continue block4;
                    state = -1;
                    continue block4;
                }
                case 2: {
                    if (c == ' ' || i == str.length() - 1) {
                        if (str.charAt(i - 1) == '-' || dotCountAfterAtrt == 0 || labelCounter <= 2) {
                            state = -1;
                            continue block4;
                        }
                        return i;
                    }
                    if (c == '/' || c == '=' || c == '?' || c == '<' || c == '>' || c == '@') {
                        state = -1;
                        continue block4;
                    }
                    if (c == '-') {
                        if (i - 1 == atrtIdx) {
                            state = -1;
                        }
                    } else if (c == '.') {
                        labelCounter = 1;
                        if (i + 1 < str.length() && str.charAt(i + 1) != ' ') {
                            ++dotCountAfterAtrt;
                        }
                        if (i + 1 < str.length() && str.charAt(i + 1) == ' ' && dotCountAfterAtrt > 0) {
                            labelCounter = 3;
                        }
                    } else if (!Util.isAlpha(c) && !Util.isNumber(c) && c != '.') {
                        state = -1;
                    } else if (labelCounter > 63) {
                        state = -1;
                    }
                    ++labelCounter;
                }
            }
        }
        return null;
    }

    public static Pair<Integer, String> reCheckForAccount(String str) {
        int i;
        int state = 1;
        int num = 0;
        boolean account = false;
        StringBuilder sb = new StringBuilder("");
        for (i = 0; state > 0 && i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (Util.isAlpha(c)) {
                        state = 2;
                        break;
                    }
                    if (Util.isNumber(c)) {
                        sb.append(c);
                        ++num;
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (Util.isAlpha(c) || c == '/' || c == '-') {
                        num = 0;
                        state = 2;
                        break;
                    }
                    if (Util.isNumber(c)) {
                        sb.append(c);
                        ++num;
                        state = 2;
                        break;
                    }
                    num = 0;
                    state = -1;
                }
            }
            if (num < 4) continue;
            account = true;
        }
        if (account) {
            return new Pair<Integer, String>(i - 1, StateMachines.instrnoValidate(sb.toString()));
        }
        return null;
    }

    private static String instrnoValidate(String numString) {
        if (numString.length() < 4) {
            return null;
        }
        numString = numString.substring(numString.length() - 4);
        return numString;
    }

    public static Pair<Integer, String> checkForId(String str, int startIndex) {
        int state = 1;
        int i = 0;
        boolean haveSeenUpper = false;
        boolean haveSeenNumber = false;
        boolean haveSeenLower = false;
        boolean validID = false;
        StringBuilder sb = new StringBuilder("");
        if (i < str.length() && str.charAt(i) == '\'') {
            ++i;
        }
        while (state > 0 && i < str.length()) {
            char c = str.charAt(i);
            switch (state) {
                case 1: {
                    if (Util.isNumber(c) || Util.isAlpha(c)) {
                        if (Util.isUpperAlpha(c)) {
                            haveSeenUpper = true;
                        } else if (Util.isLowerAlpha(c)) {
                            haveSeenLower = true;
                        } else {
                            haveSeenNumber = true;
                        }
                        sb.append(c);
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    if (Util.isNumber(c) || Util.isAlpha(c) || c == '_') {
                        if (Util.isUpperAlpha(c)) {
                            haveSeenUpper = true;
                        } else if (Util.isLowerAlpha(c)) {
                            haveSeenLower = true;
                        } else if (Util.isNumber(c)) {
                            haveSeenNumber = true;
                        }
                        sb.append(c);
                        state = 2;
                        break;
                    }
                    if (c == '\'' || c == '-' && (i + 1 >= str.length() || str.charAt(i + 1) != ' ')) {
                        state = 2;
                        break;
                    }
                    if (i + 3 < str.length() && str.substring(i, i + 3).equalsIgnoreCase(" - ") && Character.isLetterOrDigit(str.charAt(i + 3))) {
                        Pair<Integer, String> id = null;
                        id = StateMachines.checkForId(str.substring(i + 3), startIndex + i);
                        if (id != null) {
                            sb.append(id.getB());
                            state = -1;
                            break;
                        }
                        state = -1;
                        break;
                    }
                    state = -1;
                }
            }
            ++i;
        }
        validID = haveSeenUpper ? (!haveSeenNumber ? !haveSeenLower : true) : (!haveSeenNumber ? false : haveSeenLower);
        if (sb.length() > 0 && validID) {
            return new Pair<Integer, String>(i - 1, sb.toString());
        }
        return null;
    }

    private static int lookAheadIntegerForUPI(String sentence) {
        int index;
        for (index = 0; index < sentence.length(); ++index) {
            char c = sentence.charAt(index);
            if (StateMachines.isUPIDelimeter(c) || Util.isLowerAlpha(c) || Util.isUpperAlpha(c)) continue;
            if (Util.isNumber(c)) {
                if (index + 1 >= sentence.length() || !Util.isNumber(sentence.charAt(index + 1))) continue;
                break;
            }
            return -1;
        }
        return index;
    }

    private static boolean isUPIDelimeter(char c) {
        return c == '-' || c == '/' || c == '*';
    }
}

