/*
 * Decompiled with CFR 0.152.
 */
package com.twelfthmile.yuga.types;

import com.twelfthmile.yuga.types.TrieNode;
import com.twelfthmile.yuga.utils.Constants;

public class Trie {
    public TrieNode root = new TrieNode();

    public void insert(String word, String label) {
        TrieNode node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char currentChar = word.charAt(i);
            if (!node.hasNext(currentChar)) {
                node.put(currentChar, new TrieNode());
            }
            node = node.get(currentChar);
        }
        node.setEnd();
        node.setLabel(label);
    }

    public void insertUpis() {
        String label = "UPI";
        for (int i = 0; i < Constants.upi.length; ++i) {
            this.insert(Constants.upi[i], label);
        }
    }

    private void insertCurr() {
        String label = "CRNCY";
        for (int i = 0; i < Constants.curr.length; ++i) {
            this.insert(Constants.curr[i], label);
        }
    }

    private void insertInstr() {
        String label = "INSTR";
        for (int i = 0; i < Constants.instr.length; ++i) {
            this.insert(Constants.instr[i], label);
        }
    }

    private void insertFltId() {
        String label = "FLTID";
        for (int i = 0; i < Constants.fltid.length; ++i) {
            this.insert(Constants.fltid[i], label);
        }
    }

    public void loadTrie() {
        this.insertCurr();
        this.insertInstr();
        this.insertFltId();
    }
}

